/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.jboss.ws.tools.io.NullPrintStream;
import org.jboss.wsf.spi.tools.WSContractConsumer;

public class CXFConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles = null;
    private File catalog = null;
    private boolean extension;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target;
    private boolean nocompile = false;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void consume(URL wsdl) {
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (!this.nocompile) {
            args.add("-compile");
        }
        args.add("-exsh");
        args.add(this.additionalHeaders ? "true" : "false");
        if (this.generateSource && this.sourceDir == null) {
            this.sourceDir = this.outputDir;
        }
        if (this.sourceDir != null && this.generateSource) {
            if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
            }
            args.add("-d");
            args.add(this.sourceDir.getAbsolutePath());
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdlLocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
        } else {
            stream = NullPrintStream.getInstance();
        }
        if (this.extension) {
            stream.println("TODO! Cheek SOAP 1.2 extension");
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
        }
        if (!this.nocompile) {
            args.add("-classdir");
            args.add(this.outputDir.getAbsolutePath());
        }
        if (this.nocompile && !this.generateSource) {
            args.add("-d");
            args.add(this.outputDir.getAbsolutePath());
        }
        if (this.target != null) {
            stream.println("WSConsume (CXF) does not allow to setup the JAX-WS specification target, using the currently configured JAX-WS version (check your JVM version and/or endorsed libs)");
        }
        args.add("-allowElementReferences");
        args.add(wsdl.toString());
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        WSDLToJava w2j = new WSDLToJava(args.toArray(new String[0]));
        try {
            w2j.run(new ToolContext(), (OutputStream)stream);
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke WSDLToJava");
                t.printStackTrace(this.messageStream);
            }
            t.printStackTrace();
        }
    }
}

