/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Map;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.binding.JAXBBindingCustomization;

public class JBossWSCXFConfigurer
implements Configurer {
    protected BindingCustomization customization;
    private Configurer delegate;

    public JBossWSCXFConfigurer(Configurer delegate) {
        this.delegate = delegate;
    }

    public JBossWSCXFConfigurer(Configurer delegate, BindingCustomization customization) {
        this(delegate);
        this.customization = customization;
    }

    public void configureBean(Object beanInstance) {
        this.internalConfigure(beanInstance);
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        this.internalConfigure(beanInstance);
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    protected void internalConfigure(Object beanInstance) {
        if (beanInstance instanceof AbstractWSDLBasedEndpointFactory) {
            this.configureEndpointFactory((AbstractWSDLBasedEndpointFactory)beanInstance);
        } else if (beanInstance instanceof ClientProxyFactoryBean) {
            this.configureClientProxyFactoryBean((ClientProxyFactoryBean)beanInstance);
        }
    }

    protected synchronized void configureEndpointFactory(AbstractWSDLBasedEndpointFactory factory) {
    }

    protected synchronized void configureClientProxyFactoryBean(ClientProxyFactoryBean factory) {
        if (this.customization != null) {
            ReflectionServiceFactoryBean serviceFactory = factory.getServiceFactory();
            serviceFactory.reset();
            DataBinding serviceFactoryDataBinding = serviceFactory.getDataBinding(true);
            JBossWSCXFConfigurer.setBindingCustomization(serviceFactoryDataBinding, this.customization);
            serviceFactory.setDataBinding(serviceFactoryDataBinding);
            if (factory.getDataBinding() == null) {
                factory.setDataBinding(serviceFactoryDataBinding);
            } else {
                JBossWSCXFConfigurer.setBindingCustomization(factory.getDataBinding(), this.customization);
            }
        }
    }

    protected static void setBindingCustomization(DataBinding db, BindingCustomization customization) {
        if (customization instanceof JAXBBindingCustomization && db != null && db instanceof JAXBDataBinding) {
            ((JAXBDataBinding)db).setContextProperties((Map)customization);
        }
    }

    public void setBindingCustomization(BindingCustomization customization) {
        this.customization = customization;
    }
}

