/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class ServiceRefStubPropertyConfigurer
implements Configurer {
    private UnifiedServiceRefMetaData serviceRefMD;
    private Configurer delegate;

    public ServiceRefStubPropertyConfigurer(UnifiedServiceRefMetaData serviceRefMD, Configurer delegate) {
        this.serviceRefMD = serviceRefMD;
        this.delegate = delegate;
    }

    public void configureBean(Object beanInstance) {
        if (beanInstance instanceof JaxWsProxyFactoryBean) {
            this.configureJaxWsProxyFactoryBean((JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        if (beanInstance instanceof JaxWsProxyFactoryBean) {
            this.configureJaxWsProxyFactoryBean((JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    private synchronized void configureJaxWsProxyFactoryBean(JaxWsProxyFactoryBean proxyFactory) {
        Class clazz = proxyFactory.getServiceClass();
        UnifiedPortComponentRefMetaData upcmd = this.serviceRefMD.getPortComponentRef(clazz != null ? clazz.getName() : null, ServiceRefStubPropertyConfigurer.getServiceName(proxyFactory));
        if (upcmd != null) {
            this.setProperties(proxyFactory, upcmd);
            this.setMTOM((JaxWsServiceFactoryBean)proxyFactory.getServiceFactory(), upcmd);
        }
    }

    private static QName getServiceName(JaxWsProxyFactoryBean proxyFactory) {
        try {
            return proxyFactory.getServiceName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setMTOM(JaxWsServiceFactoryBean serviceFactoryBean, UnifiedPortComponentRefMetaData upcmd) {
        if (upcmd.getEnableMTOM().booleanValue()) {
            LinkedList<MTOMFeature> features = new LinkedList<MTOMFeature>();
            List prevFeatures = serviceFactoryBean.getWsFeatures();
            if (prevFeatures != null) {
                features.addAll(prevFeatures);
            }
            features.add(new MTOMFeature(true));
            serviceFactoryBean.setWsFeatures(features);
        }
    }

    private void setProperties(JaxWsProxyFactoryBean proxyFactory, UnifiedPortComponentRefMetaData upcmd) {
        HashMap<String, String> properties = proxyFactory.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            proxyFactory.setProperties(properties);
        }
        for (UnifiedStubPropertyMetaData prop : upcmd.getStubProperties()) {
            properties.put(prop.getPropName(), prop.getPropValue());
        }
    }
}

