/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.type.archive;

import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;

public class ZipMetadata
extends ArchiveMetadata {
    private static final Log LOG = LogFactory.getLog(ZipMetadata.class);
    protected ZipFile zip;

    public ZipFile getZipFile() {
        if (this.zip != null) {
            return this.zip;
        }
        if (this.filePointer != null) {
            try {
                this.zip = new ZipFile(this.filePointer);
            }
            catch (Exception e) {
                LOG.error((Object)("Bad Zip? " + this.filePointer.getAbsolutePath()));
                LOG.info((Object)"Skipping file. Continuing Windup Processing...");
                Summary sr = new Summary();
                sr.setDescription("Bad Zip? Unable to parse.");
                sr.setLevel(AbstractDecoration.NotificationLevel.CRITICAL);
                sr.setEffort(new UnknownEffort());
                this.getDecorations().add(sr);
                this.zip = null;
            }
        }
        return this.zip;
    }
}

