/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.type;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.util.LocationAwareXmlReader;
import org.w3c.dom.Document;

public class XmlMetadata
extends FileMetadata {
    private static final Log LOG = LogFactory.getLog(XmlMetadata.class);
    protected SoftReference<Document> parsedDocumentRef;

    @Override
    public void setFilePointer(File filePointer) {
        super.setFilePointer(filePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document hydrateDocument() {
        if (this.parsedDocumentRef == null) {
            FileInputStream fis = null;
            try {
                fis = FileUtils.openInputStream((File)this.filePointer);
                Document parsedDocument = LocationAwareXmlReader.readXML(fis);
                LOG.debug((Object)("Hydrating XML Document: " + this.filePointer.getAbsolutePath()));
                this.parsedDocumentRef = new SoftReference<Document>(parsedDocument);
            }
            catch (Exception e) {
                LOG.error((Object)("Bad XML? " + this.filePointer.getAbsolutePath()));
                LOG.info((Object)"Skipping file. Continuing Windup Processing...");
                Summary sr = new Summary();
                sr.setDescription("Bad XML? Unable to parse.");
                sr.setLevel(AbstractDecoration.NotificationLevel.CRITICAL);
                sr.setEffort(new UnknownEffort());
                this.getDecorations().add(sr);
                this.parsedDocumentRef = null;
                Document document = null;
                return document;
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        return this.parsedDocumentRef.get();
    }

    public Document getParsedDocument() {
        return this.hydrateDocument();
    }

    public void releaseParsedDocument() {
        this.parsedDocumentRef = null;
    }

    public void setParsedDocument(Document parsedDocument) {
        this.parsedDocumentRef = new SoftReference<Document>(parsedDocument);
    }

    public String toString() {
        return "XmlMetadata [decorations=" + this.decorations + ", filePointer=" + this.filePointer + "]";
    }
}

