/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.type;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.type.FileMetadata;

public class TempSourceMetadata
extends FileMetadata {
    private static final Log LOG = LogFactory.getLog(TempSourceMetadata.class);
    private final File source;

    public TempSourceMetadata(File source) {
        this.source = source;
    }

    @Override
    public File getFilePointer() {
        File archiveOutputDirectory = this.getArchiveMeta().getArchiveOutputDirectory();
        File targetFile = null;
        if (archiveOutputDirectory != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copy source file '" + this.source.getName() + "' to target '" + archiveOutputDirectory.getAbsolutePath() + "'"));
            }
            String fileName = this.source.getName();
            String fullName = archiveOutputDirectory.getAbsolutePath() + File.separatorChar + fileName;
            targetFile = new File(fullName);
            try {
                FileUtils.copyFile((File)this.source, (File)targetFile);
            }
            catch (IOException e) {
                LOG.error((Object)"Exception copying file.", (Throwable)e);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No output directroy specified, returning source file: " + this.source));
            }
            targetFile = this.source;
        }
        return targetFile;
    }
}

