/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.type;

import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.FileMetadata;

public class ManifestMetadata
extends FileMetadata {
    private static final Log LOG = LogFactory.getLog(ManifestMetadata.class);
    protected SoftReference<Manifest> manifest;

    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reading manifest: " + this.filePointer.getAbsolutePath()));
                }
                Manifest mTmp = new Manifest(new FileInputStream(this.filePointer));
                this.manifest = new SoftReference<Manifest>(mTmp);
                LOG.debug((Object)"Reading manifest complete.");
            }
            catch (Exception e) {
                LOG.error((Object)("Bad Manifest? " + this.filePointer.getAbsolutePath()));
                LOG.info((Object)"Skipping file. Continuing Windup Processing...");
                Summary sr = new Summary();
                sr.setDescription("Bad Manifest? Unable to parse.");
                sr.setLevel(AbstractDecoration.NotificationLevel.CRITICAL);
                sr.setEffort(new UnknownEffort());
                this.getDecorations().add(sr);
                this.manifest = null;
            }
        }
        if (this.manifest == null) {
            return null;
        }
        return this.manifest.get();
    }
}

