/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.profile;

import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.graph.clz.ProfileClz;
import org.jboss.windup.graph.profile.Profile;

public class ProfileArchive
implements Profile {
    private String archiveName;
    private String moduleIdentifier;
    private Set<ProfileClz> classes;

    public ProfileArchive(String archiveName, String moduleIdentifier) {
        this.archiveName = archiveName;
        this.moduleIdentifier = moduleIdentifier;
        this.classes = new HashSet<ProfileClz>();
    }

    @Override
    public boolean doesProvide(String clz) {
        return this.classes.contains(clz);
    }

    @Override
    public Set<ProfileClz> getProvided() {
        return this.classes;
    }

    @Override
    public String getName() {
        return this.archiveName;
    }

    @Override
    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public void addClass(ProfileClz className) {
        this.classes.add(className);
    }
}

