/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.util.List;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.windup.bootstrap.Bootstrap;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.addons.AddImmutableAddonDirectoryCommand;
import org.jboss.windup.tooling.ToolingRMIServer;

public class ServerModeCommand
implements Command {
    public static final String COMMAND_ID = "--startServer";
    private Furnace furnace;
    private int port;
    private String addonsDirectory;

    public ServerModeCommand(List<String> arguments) {
        this.port = ServerModeCommand.getServerPort(arguments);
        this.addonsDirectory = ServerModeCommand.getAddonDirectory(arguments);
    }

    public static boolean isServerMode(List<String> arguments) {
        return arguments.contains(COMMAND_ID);
    }

    private static String getAddonDirectory(List<String> arguments) {
        int addDirectoryIndex = arguments.indexOf("--immutableAddonDir") + 1;
        return arguments.get(addDirectoryIndex);
    }

    private static int getServerPort(List<String> arguments) {
        int serverPort = arguments.indexOf(COMMAND_ID) + 1;
        String serverPortString = arguments.get(serverPort);
        return Integer.valueOf(serverPortString);
    }

    @Override
    public CommandResult execute() {
        try {
            this.furnace = FurnaceFactory.getInstance();
            this.furnace.setServerMode(true);
            this.loadAddons();
            try {
                Future future = this.furnace.startAsync();
                future.get();
            }
            catch (Exception e) {
                System.out.println("Failed to start Windup!");
                if (e.getMessage() != null) {
                    System.out.println("Failure reason: " + e.getMessage());
                }
                e.printStackTrace();
            }
            this.startServer();
        }
        catch (Throwable t) {
            System.err.println("Windup execution failed due to: " + t.getMessage());
            t.printStackTrace();
        }
        System.out.println("Server started...");
        return null;
    }

    private void loadAddons() {
        AddImmutableAddonDirectoryCommand addonCommand = new AddImmutableAddonDirectoryCommand(this.addonsDirectory);
        addonCommand.setFurnace(this.furnace);
        addonCommand.execute();
    }

    private void startServer() {
        System.out.println("Calling ToolingRMIServer start...");
        ((ToolingRMIServer)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(ToolingRMIServer.class).get()).startServer(this.port, Bootstrap.getVersion());
    }

    private void stop() {
        if (this.furnace != null && !this.furnace.getStatus().isStopped()) {
            this.furnace.stop();
        }
    }

    @Override
    public CommandPhase getPhase() {
        return null;
    }
}

