/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.bootstrap.Bootstrap;
import org.jboss.windup.bootstrap.ConsoleProgressMonitor;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.bootstrap.commands.windup.GenerateCompletionDataCommand;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.util.exception.WindupException;

public class RunWindupCommand
implements Command,
FurnaceDependent {
    private Furnace furnace;
    private List<String> arguments;
    private AtomicBoolean batchMode;

    public RunWindupCommand(List<String> arguments, AtomicBoolean batchMode) {
        this.arguments = arguments;
        this.batchMode = batchMode;
    }

    @Override
    public CommandResult execute() {
        this.runWindup(this.arguments);
        return CommandResult.EXIT;
    }

    @Override
    public void setFurnace(Furnace furnace) {
        this.furnace = furnace;
    }

    @Override
    public CommandPhase getPhase() {
        return CommandPhase.EXECUTION;
    }

    private void runWindup(List<String> arguments) {
        String string;
        boolean validationSuccess;
        Iterable optionIterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnace);
        HashMap<String, ConfigurationOption> options = new HashMap<String, ConfigurationOption>();
        for (ConfigurationOption option : optionIterable) {
            options.put(option.getName().toUpperCase(), option);
        }
        HashMap<String, Object> optionValues = new HashMap<String, Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            String optionName = this.getOptionName(argument);
            if (optionName == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            ConfigurationOption option = (ConfigurationOption)options.get(optionName.toUpperCase());
            if (option == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            if (option.getUIType() == InputType.MANY || option.getUIType() == InputType.SELECT_MANY) {
                ArrayList<Object> values = new ArrayList<Object>();
                ++i;
                while (i < arguments.size()) {
                    if (this.getOptionName(arguments.get(i)) != null && options.containsKey(this.getOptionName(arguments.get(i).toUpperCase()))) {
                        --i;
                        break;
                    }
                    String string2 = arguments.get(i);
                    for (String value : StringUtils.split((String)string2, (char)' ')) {
                        values.add(this.convertType(option.getType(), value));
                    }
                    ++i;
                }
                if (optionValues.containsKey(option.getName())) {
                    ((List)optionValues.get(option.getName())).addAll(values);
                    continue;
                }
                optionValues.put(option.getName(), values);
                continue;
            }
            if (Boolean.class.isAssignableFrom(option.getType())) {
                optionValues.put(option.getName(), true);
                continue;
            }
            String valueString = arguments.get(++i);
            optionValues.put(option.getName(), this.convertType(option.getType(), valueString));
        }
        this.setDefaultOutputPath(optionValues);
        RuleProviderRegistryCache ruleProviderRegistryCache = (RuleProviderRegistryCache)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(RuleProviderRegistryCache.class).get();
        Set<String> targets = (Set<String>)optionValues.get("target");
        if ((targets == null || targets.isEmpty()) && !this.batchMode.get()) {
            String target = Bootstrap.promptForListItem("Please select a target:", ruleProviderRegistryCache.getAvailableTargetTechnologies(), "eap");
            targets = Collections.singleton(target);
            optionValues.put("target", targets);
        }
        if (!(validationSuccess = this.validateOptionValues(options, optionValues))) {
            return;
        }
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (Map.Entry entry : options.entrySet()) {
            ConfigurationOption option = (ConfigurationOption)entry.getValue();
            windupConfiguration.setOptionValue(option.getName(), optionValues.get(option.getName()));
        }
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to create default directories due to: " + e.getMessage());
            return;
        }
        Boolean overwrite = (Boolean)windupConfiguration.getOptionMap().get("overwrite");
        if (overwrite == null) {
            overwrite = false;
        }
        if (!overwrite.booleanValue() && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile()) && !Bootstrap.prompt(string = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?", false, this.batchMode.get())) {
            String outputPath = windupConfiguration.getOutputDirectory().toString();
            System.err.println("Files exist in " + outputPath + ", but --overwrite not specified. Aborting!");
            return;
        }
        GenerateCompletionDataCommand generateCompletionDataCommand = new GenerateCompletionDataCommand(false);
        generateCompletionDataCommand.setFurnace(this.furnace);
        generateCompletionDataCommand.execute();
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        Path graphPath = windupConfiguration.getOutputDirectory().resolve("graph");
        try (GraphContext graphContext = this.getGraphContextFactory().create(graphPath);){
            ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor).setGraphContext(graphContext);
            this.getWindupProcessor().execute(windupConfiguration);
            Path indexHtmlPath = windupConfiguration.getOutputDirectory().resolve("index.html").normalize().toAbsolutePath();
            System.out.println("Windup report created: " + indexHtmlPath + System.getProperty("line.separator") + "              Access it at this URL: " + indexHtmlPath.toUri());
        }
        catch (Exception e) {
            System.err.println("Windup Execution failed due to: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean validateOptionValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> optionEntry : options.entrySet()) {
            ConfigurationOption option = optionEntry.getValue();
            ValidationResult result = option.validate(optionValues.get(option.getName()));
            switch (result.getLevel()) {
                case ERROR: {
                    System.err.println("ERROR: " + result.getMessage());
                    return false;
                }
                case PROMPT_TO_CONTINUE: {
                    if (Bootstrap.prompt(result.getMessage(), result.getPromptDefault(), this.batchMode.get())) break;
                    return false;
                }
                case WARNING: {
                    System.err.println("WARNING: " + result.getMessage());
                    break;
                }
            }
        }
        return true;
    }

    private void setDefaultOutputPath(Map<String, Object> optionValues) {
        File inputFile;
        if (!optionValues.containsKey("output") && (inputFile = (File)optionValues.get("input")) != null) {
            try {
                File canonicalInputFile = inputFile.getCanonicalFile();
                File outputFile = new File(canonicalInputFile.getParentFile(), canonicalInputFile.getName() + ".report");
                optionValues.put("output", outputFile);
            }
            catch (IOException e) {
                throw new WindupException("Failed to get canonical path for input file: " + inputFile);
            }
        }
    }

    private Object convertType(Class<?> type, String input) {
        if (File.class.isAssignableFrom(type)) {
            return new File(input);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(input);
        }
        if (String.class.isAssignableFrom(type)) {
            return input;
        }
        throw new RuntimeException("Internal Error! Unrecognized type " + type.getCanonicalName());
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    private WindupProcessor getWindupProcessor() {
        return (WindupProcessor)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupProcessor.class).get();
    }

    private GraphContextFactory getGraphContextFactory() {
        return (GraphContextFactory)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(GraphContextFactory.class).get();
    }

    private String getOptionName(String argument) {
        if (argument.startsWith("--")) {
            return argument.substring(2);
        }
        if (argument.startsWith("-")) {
            return argument.substring(1);
        }
        return null;
    }
}

