/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.validators;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jboss.windup.web.services.validators.FileExistsConstraint;

public class FileExistsValidator
implements ConstraintValidator<FileExistsConstraint, String> {
    private static Logger LOG = Logger.getLogger(FileExistsValidator.class.getSimpleName());

    public void initialize(FileExistsConstraint constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value != null) {
            LOG.info("Validating path: " + Paths.get(value, new String[0]).toAbsolutePath().normalize().toString());
        }
        if ("WINDUP_FILE_DELETED".equals(value)) {
            return true;
        }
        return value != null && Files.exists(Paths.get(value, new String[0]), new LinkOption[0]);
    }
}

