/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
public class Tag {
    public static final String TAG_ID = "tag_id";
    public static final String TAG_NAME = "name";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="tag_id", updatable=false, nullable=false)
    private Long id;
    @Column(name="name", length=256)
    @Size(min=0, max=256)
    @NotNull
    private @Size(min=0, max=256) @NotNull String name;
    @Column
    @Type(type="yes_no")
    private boolean isRoot;
    @Column
    @Type(type="yes_no")
    private boolean isPseudo;
    @Column
    private String color;
    @Column
    private String title;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="parent")
    @Fetch(value=FetchMode.SELECT)
    private Set<Tag> containedTags = new HashSet<Tag>();
    @ManyToOne
    @JsonIgnore
    private Tag parent;

    public Tag() {
    }

    public Tag(String name) {
        this();
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Tag setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Tag setRoot(boolean root) {
        this.isRoot = root;
        return this;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public Tag setPseudo(boolean pseudo) {
        this.isPseudo = pseudo;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public Tag setColor(String color) {
        this.color = color;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Tag setTitle(String title) {
        this.title = title;
        return this;
    }

    public Set<Tag> getContainedTags() {
        return this.containedTags;
    }

    public Tag setContainedTags(Set<Tag> containedTags) {
        this.containedTags = containedTags;
        return this;
    }

    public Tag addContainedTag(Tag tag) {
        this.containedTags.add(tag);
        return this;
    }

    public Tag getParent() {
        return this.parent;
    }

    public Tag setParent(Tag parent) {
        this.parent = parent;
        return this;
    }
}

