/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.jboss.windup.web.services.model.RuleEntity;
import org.jboss.windup.web.services.model.RulesPath;
import org.jboss.windup.web.services.model.Tag;
import org.jboss.windup.web.services.model.Technology;

@Entity
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=RuleProviderEntity.class)
@NamedQueries(value={@NamedQuery(name="RuleProviderEntity.findAll", query="select rpe from RuleProviderEntity rpe"), @NamedQuery(name="RuleProviderEntity.deleteAll", query="delete from RuleProviderEntity"), @NamedQuery(name="RuleProviderEntity.deleteByRulesPath", query="delete from RuleProviderEntity rpe where rpe.rulesPath = :rulesPath"), @NamedQuery(name="RuleProviderEntity.deleteNullPath", query="delete from RuleProviderEntity rpe where rpe.rulesPath is null")})
public class RuleProviderEntity
implements Serializable {
    public static final String FIND_ALL = "RuleProviderEntity.findAll";
    public static final String DELETE_ALL = "RuleProviderEntity.deleteAll";
    public static final String DELETE_BY_RULES_PATH = "RuleProviderEntity.deleteByRulesPath";
    public static final String DELETE_WITH_NULL_RULES_PATH = "RuleProviderEntity.deleteNullPath";
    public static final String RULES_PATH_PARAM = "rulesPath";
    public static final String RULE_PROVIDER_ENTITY_ID = "rule_provider_entity_id";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="rule_provider_entity_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column(name="provider_id")
    private String providerID;
    @Column(name="origin", length=2048)
    private String origin;
    @Column(name="description", length=8192)
    private String description;
    @Column(name="phase")
    private String phase;
    @Column(name="date_loaded")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dateLoaded;
    @Column(name="date_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dateModified;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ruleproviderentity_technology_source", joinColumns={@JoinColumn(name="rule_provider_entity_id", referencedColumnName="rule_provider_entity_id")}, inverseJoinColumns={@JoinColumn(name="technology_id", referencedColumnName="technology_id")})
    private Set<Technology> sources = new HashSet<Technology>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ruleproviderentity_technology_target", joinColumns={@JoinColumn(name="rule_provider_entity_id", referencedColumnName="rule_provider_entity_id")}, inverseJoinColumns={@JoinColumn(name="technology_id", referencedColumnName="technology_id")})
    private Set<Technology> targets = new HashSet<Technology>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderColumn(name="rule_sequence")
    private List<RuleEntity> rules = new ArrayList<RuleEntity>();
    @ManyToOne(fetch=FetchType.EAGER)
    private RulesPath rulesPath;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<Tag> tags = new HashSet<Tag>();
    @Lob
    private String loadError;
    @Column
    private RuleProviderType ruleProviderType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Calendar getDateLoaded() {
        return this.dateLoaded;
    }

    public void setDateLoaded(Calendar dateLoaded) {
        this.dateLoaded = dateLoaded;
    }

    public Calendar getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Calendar dateModified) {
        this.dateModified = dateModified;
    }

    public Set<Technology> getSources() {
        return this.sources;
    }

    public void setSources(Set<Technology> sources) {
        this.sources = sources;
    }

    public Set<Technology> getTargets() {
        return this.targets;
    }

    public void setTargets(Set<Technology> targets) {
        this.targets = targets;
    }

    public List<RuleEntity> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleEntity> rules) {
        this.rules = rules;
    }

    public RulesPath getRulesPath() {
        return this.rulesPath;
    }

    public void setRulesPath(RulesPath rulesPath) {
        this.rulesPath = rulesPath;
    }

    public RuleProviderType getRuleProviderType() {
        return this.ruleProviderType;
    }

    public void setRuleProviderType(RuleProviderType ruleProviderType) {
        this.ruleProviderType = ruleProviderType;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    public String getLoadError() {
        return this.loadError;
    }

    public void setLoadError(String loadError) {
        this.loadError = loadError;
    }

    public static enum RuleProviderType {
        JAVA,
        XML,
        GROOVY;

    }
}

