/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import javax.validation.constraints.Size;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Type;
import org.jboss.windup.web.services.model.MigrationProject;
import org.jboss.windup.web.services.model.PackageMetadata;
import org.jboss.windup.web.services.model.RegistrationType;
import org.jboss.windup.web.services.validators.FileExistsConstraint;

@Entity
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=RegisteredApplication.class)
public class RegisteredApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String REGISTERED_APPLICATION_ID = "registered_application_id";
    @Id
    @Access(value=AccessType.PROPERTY)
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="registered_application_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column
    private RegistrationType registrationType;
    @Column(length=256)
    @Size(min=1, max=256, message="The application title must be set and not longer than 250 characters.")
    private @Size(min=1, max=256, message="The application title must be set and not longer than 250 characters.") String title;
    @Column(name="file_size", nullable=false)
    @ColumnDefault(value="0")
    private long fileSize;
    @Column(length=2048)
    @FileExistsConstraint(message="The path does not exist on the server: ${validatedValue}")
    @Size(min=1, max=2048, message="The application title path must be set and not longer than 2048 characters.")
    private @Size(min=1, max=2048, message="The application title path must be set and not longer than 2048 characters.") String inputPath;
    @Column(nullable=false)
    @ColumnDefault(value="FALSE")
    @Type(type="yes_no")
    private boolean exploded;
    @Column(length=2048)
    private String reportIndexPath;
    @ManyToOne
    private MigrationProject migrationProject;
    @OneToOne(fetch=FetchType.LAZY)
    private PackageMetadata packageMetadata;
    @Column(columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", insertable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar created;
    @Column(columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar lastModified;
    @Column
    @Type(type="yes_no")
    private boolean isDeleted = false;

    public RegisteredApplication() {
    }

    public RegisteredApplication(String inputPath) {
        this();
        this.inputPath = inputPath;
        this.title = Paths.get(inputPath, new String[0]).getFileName().toString();
    }

    public RegisteredApplication(MigrationProject project) {
        this();
        this.migrationProject = project;
    }

    @PrePersist
    protected void onCreate() {
        this.created = this.lastModified = new GregorianCalendar();
    }

    @PreUpdate
    protected void onUpdated() {
        this.lastModified = new GregorianCalendar();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public RegistrationType getRegistrationType() {
        return this.registrationType;
    }

    public void setRegistrationType(RegistrationType registrationType) {
        this.registrationType = registrationType;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public void setExploded(boolean exploded) {
        this.exploded = exploded;
    }

    public String getInputFilename() {
        if (this.getInputPath() == null) {
            return null;
        }
        return Paths.get(this.getInputPath(), new String[0]).getFileName().toString();
    }

    public void setInputFilename(String inputFilename) {
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
        if (this.getInputPath() == null) {
            this.setInputFilename("");
        } else {
            this.setInputFilename(Paths.get(this.getInputPath(), new String[0]).getFileName().toString());
        }
    }

    public String getReportIndexPath() {
        return this.reportIndexPath;
    }

    public void setReportIndexPath(String reportIndexPath) {
        this.reportIndexPath = reportIndexPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @JsonIgnore
    public PackageMetadata getPackageMetadata() {
        return this.packageMetadata;
    }

    public void setPackageMetadata(PackageMetadata packageMetadata) {
        this.packageMetadata = packageMetadata;
    }

    @JsonIgnore
    public MigrationProject getMigrationProject() {
        return this.migrationProject;
    }

    public void setMigrationProject(MigrationProject migrationProject) {
        this.migrationProject = migrationProject;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        if (deleted) {
            this.setInputPath("WINDUP_FILE_DELETED");
        }
        this.isDeleted = deleted;
    }

    public String toString() {
        String result = this.getClass().getSimpleName() + " ";
        if (this.id != null) {
            result = result + "id: " + this.id;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegisteredApplication)) {
            return false;
        }
        RegisteredApplication other = (RegisteredApplication)obj;
        if (this.id != null) {
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }
}

