/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.jboss.windup.web.services.model.AnalysisContext;
import org.jboss.windup.web.services.model.Configuration;
import org.jboss.windup.web.services.model.RegisteredApplication;
import org.jboss.windup.web.services.model.WindupExecution;

@Entity
@Table
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=MigrationProject.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MigrationProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIGRATION_PROJECT_ID = "migration_project_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="migration_project_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column(nullable=true)
    @ColumnDefault(value="FALSE")
    @Type(type="yes_no")
    private boolean provisional = true;
    @Column(length=120, unique=false, nullable=false)
    @Size(min=3, max=120, message="The name must be at least 3 letters long.")
    @Pattern(message="The name must contain only alphanumeric characters and spaces", regexp="\\s*[- \\w]+\\s*")
    @NotNull
    private @Size(min=3, max=120, message="The name must be at least 3 letters long.") @Pattern(message="The name must contain only alphanumeric characters and spaces", regexp="\\s*[- \\w]+\\s*") @NotNull String title;
    @Size(max=4096)
    @NotNull
    @Column(length=4096, nullable=false)
    private @Size(max=4096) @NotNull String description = "";
    @Column(columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", insertable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar created;
    @Column(columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar lastModified;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="migrationProject", cascade={CascadeType.REMOVE})
    @Fetch(value=FetchMode.SELECT)
    private Set<RegisteredApplication> applications = new HashSet<RegisteredApplication>();
    @OneToMany(fetch=FetchType.EAGER, mappedBy="project", cascade={CascadeType.REMOVE})
    @Fetch(value=FetchMode.SELECT)
    private Set<WindupExecution> executions = new HashSet<WindupExecution>();
    @OneToOne
    private AnalysisContext defaultAnalysisContext;
    @OneToOne(fetch=FetchType.LAZY)
    private Configuration configuration;

    @PrePersist
    protected void onCreate() {
        this.created = this.lastModified = new GregorianCalendar();
    }

    @PreUpdate
    protected void onUpdated() {
        this.lastModified = new GregorianCalendar();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isProvisional() {
        return this.provisional;
    }

    public void setProvisional(boolean beingCreated) {
        this.provisional = beingCreated;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    @JsonProperty
    public Set<RegisteredApplication> getApplications() {
        return this.applications;
    }

    @JsonIgnore
    public void setApplications(Set<RegisteredApplication> applications) {
        this.applications = applications;
    }

    public void addApplication(RegisteredApplication application) {
        this.applications.add(application);
    }

    public void removeApplication(RegisteredApplication application) {
        this.applications.remove(application);
    }

    public Set<WindupExecution> getExecutions() {
        return this.executions;
    }

    public void setExecutions(Set<WindupExecution> executions) {
        this.executions = executions;
    }

    public void addExecution(WindupExecution execution) {
        this.executions.add(execution);
    }

    public void removeExecution(WindupExecution execution) {
        this.executions.remove(execution);
    }

    @JsonIgnore
    public AnalysisContext getDefaultAnalysisContext() {
        return this.defaultAnalysisContext;
    }

    @JsonProperty
    public Long getDefaultAnalysisContextId() {
        Long id = null;
        if (this.defaultAnalysisContext != null) {
            id = this.defaultAnalysisContext.getId();
        }
        return id;
    }

    @JsonIgnore
    public void setDefaultAnalysisContext(AnalysisContext defaultAnalysisContext) {
        this.defaultAnalysisContext = defaultAnalysisContext;
    }

    @JsonIgnore
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @JsonIgnore
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationProject)) {
            return false;
        }
        MigrationProject that = (MigrationProject)o;
        if (this.version != that.version) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }
}

