/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Type;
import org.jboss.windup.web.services.model.PathType;
import org.jboss.windup.web.services.model.RegistrationType;
import org.jboss.windup.web.services.model.ScopeType;

@Entity
@Table(indexes={@Index(columnList="path")})
public class LabelsPath
implements Serializable {
    public static final String LABELS_PATH_ID = "labels_path_id";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="labels_path_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column(length=2048)
    @Size(min=1, max=2048)
    @NotNull
    private @Size(min=1, max=2048) @NotNull String path;
    @Column
    @NotNull
    @ColumnDefault(value="true")
    @Type(type="yes_no")
    private boolean scanRecursively = true;
    @Column(length=2048)
    @Size(min=1, max=2048)
    private @Size(min=1, max=2048) String shortPath;
    @Lob
    private String loadError;
    @Column
    private PathType labelsPathType;
    @Column
    private RegistrationType registrationType;
    @Column
    private ScopeType scopeType;

    public LabelsPath() {
    }

    public LabelsPath(String path, PathType labelsPathType, ScopeType scopeType) {
        this.path = path;
        this.labelsPathType = labelsPathType;
        this.scopeType = scopeType;
    }

    public LabelsPath(String path, PathType labelsPathType, ScopeType scopeType, RegistrationType registrationType) {
        this(path, labelsPathType, scopeType);
        this.registrationType = registrationType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String inputPath) {
        this.path = inputPath;
    }

    public boolean isScanRecursively() {
        return this.scanRecursively;
    }

    public void setScanRecursively(boolean scanRecursively) {
        this.scanRecursively = scanRecursively;
    }

    public String getShortPath() {
        return this.shortPath;
    }

    public void setShortPath(String shortPath) {
        this.shortPath = shortPath;
    }

    public PathType getLabelsPathType() {
        return this.labelsPathType;
    }

    public void setLabelsPathType(PathType labelsPathType) {
        this.labelsPathType = labelsPathType;
    }

    public String getLoadError() {
        return this.loadError;
    }

    public void setLoadError(String loadError) {
        this.loadError = loadError;
    }

    public RegistrationType getRegistrationType() {
        return this.registrationType;
    }

    public void setRegistrationType(RegistrationType registrationType) {
        this.registrationType = registrationType;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LabelsPath)) {
            return false;
        }
        LabelsPath labelsPath = (LabelsPath)o;
        if (this.path != null ? !this.path.equals(labelsPath.path) : labelsPath.path != null) {
            return false;
        }
        if (this.labelsPathType != labelsPath.labelsPathType) {
            return false;
        }
        return this.scopeType == labelsPath.scopeType;
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.labelsPathType != null ? this.labelsPathType.hashCode() : 0);
        result = 31 * result + (this.scopeType != null ? this.scopeType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LabelsPath{id=" + this.id + ", version=" + this.version + ", path='" + this.path + "', scopeType='" + this.scopeType + "', labelsPathType=" + this.labelsPathType + "}";
    }
}

