/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.jboss.windup.web.services.model.AdvancedOption;
import org.jboss.windup.web.services.model.LabelsPath;
import org.jboss.windup.web.services.model.MigrationPath;
import org.jboss.windup.web.services.model.MigrationProject;
import org.jboss.windup.web.services.model.Package;
import org.jboss.windup.web.services.model.RegisteredApplication;
import org.jboss.windup.web.services.model.RulesPath;
import org.jboss.windup.web.services.model.WindupExecution;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=AnalysisContext.class)
@NamedQueries(value={@NamedQuery(name="AnalysisContext.findAll", query="select ac from AnalysisContext ac"), @NamedQuery(name="AnalysisContext.findAllWhereExecutionIsNull", query="select a from AnalysisContext a left join a.windupExecution e where e is null"), @NamedQuery(name="AnalysisContext.findByRulePathAndExecutionIsNull", query="select a from AnalysisContext a inner join a.rulesPaths r left join a.windupExecution e where r.id = :rulePathId and e is null"), @NamedQuery(name="AnalysisContext.findByLabelPathAndExecutionIsNull", query="select a from AnalysisContext a inner join a.labelsPaths r left join a.windupExecution e where r.id = :labelPathId and e is null")})
public class AnalysisContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_ALL = "AnalysisContext.findAll";
    public static final String FIND_ALL_WHERE_EXECUTION_IS_NULL = "AnalysisContext.findAllWhereExecutionIsNull";
    public static final String FIND_BY_RULE_PATH_ID_AND_EXECUTION_IS_NULL = "AnalysisContext.findByRulePathAndExecutionIsNull";
    public static final String FIND_BY_LABEL_PATH_ID_AND_EXECUTION_IS_NULL = "AnalysisContext.findByLabelPathAndExecutionIsNull";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column(nullable=false)
    @ColumnDefault(value="true")
    @Type(type="yes_no")
    private boolean generateStaticReports = true;
    @Column(name="cloudtargets")
    @Type(type="yes_no")
    private boolean cloudTargetsIncluded;
    @Column(name="linuxtargets")
    @Type(type="yes_no")
    private boolean linuxTargetsIncluded;
    @Column(name="openjdktargets")
    @Type(type="yes_no")
    private boolean openJdkTargetsIncluded;
    @JsonIgnore
    @OneToOne(mappedBy="analysisContext", fetch=FetchType.LAZY, optional=false)
    private WindupExecution windupExecution;
    @ManyToOne(fetch=FetchType.EAGER)
    private MigrationPath migrationPath;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    private Collection<AdvancedOption> advancedOptions;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<RulesPath> rulesPaths;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<LabelsPath> labelsPaths;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="analysis_context_include_packages")
    private Set<Package> includePackages = new HashSet<Package>();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="analysis_context_exclude_packages")
    private Set<Package> excludePackages = new HashSet<Package>();
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    private Set<RegisteredApplication> applications = new HashSet<RegisteredApplication>();
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private MigrationProject migrationProject;

    public AnalysisContext() {
        this.advancedOptions = new ArrayList<AdvancedOption>();
        this.rulesPaths = new HashSet<RulesPath>();
        this.labelsPaths = new HashSet<LabelsPath>();
    }

    public AnalysisContext(MigrationProject project) {
        this();
        this.migrationProject = project;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isCloudTargetsIncluded() {
        return this.cloudTargetsIncluded;
    }

    public void setCloudTargetsIncluded(boolean cloudTargetsIncluded) {
        this.cloudTargetsIncluded = cloudTargetsIncluded;
    }

    public boolean isLinuxTargetsIncluded() {
        return this.linuxTargetsIncluded;
    }

    public void setLinuxTargetsIncluded(boolean linuxTargetsIncluded) {
        this.linuxTargetsIncluded = linuxTargetsIncluded;
    }

    public boolean isOpenJdkTargetsIncluded() {
        return this.openJdkTargetsIncluded;
    }

    public void setOpenJdkTargetsIncluded(boolean openJdkTargetsIncluded) {
        this.openJdkTargetsIncluded = openJdkTargetsIncluded;
    }

    public WindupExecution getWindupExecution() {
        return this.windupExecution;
    }

    public void setWindupExecution(WindupExecution windupExecution) {
        this.windupExecution = windupExecution;
    }

    public boolean getGenerateStaticReports() {
        return this.generateStaticReports;
    }

    public void setGenerateStaticReports(boolean generateStaticReports) {
        this.generateStaticReports = generateStaticReports;
    }

    public Set<Package> getIncludePackages() {
        return this.includePackages;
    }

    public void setIncludePackages(Set<Package> packages) {
        this.includePackages = packages;
    }

    public Set<Package> getExcludePackages() {
        return this.excludePackages;
    }

    public void setExcludePackages(Set<Package> excludePackages) {
        this.excludePackages = excludePackages;
    }

    public MigrationPath getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(MigrationPath migrationPath) {
        this.migrationPath = migrationPath;
    }

    @JsonIgnore
    public MigrationProject getMigrationProject() {
        return this.migrationProject;
    }

    public void setMigrationProject(MigrationProject migrationProject) {
        this.migrationProject = migrationProject;
    }

    public Set<RulesPath> getRulesPaths() {
        return this.rulesPaths;
    }

    public void setRulesPaths(Set<RulesPath> rulesPaths) {
        this.rulesPaths = rulesPaths;
    }

    public Set<LabelsPath> getLabelsPaths() {
        return this.labelsPaths;
    }

    public void setLabelsPaths(Set<LabelsPath> labelsPaths) {
        this.labelsPaths = labelsPaths;
    }

    public Collection<AdvancedOption> getAdvancedOptions() {
        return this.advancedOptions;
    }

    public void setAdvancedOptions(Collection<AdvancedOption> advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    public void addAdvancedOption(AdvancedOption advancedOption) {
        this.advancedOptions.add(advancedOption);
    }

    public Set<RegisteredApplication> getApplications() {
        return this.applications;
    }

    public void setApplications(Set<RegisteredApplication> applications) {
        this.applications = applications;
    }

    public void addApplication(RegisteredApplication application) {
        if (this.getApplications().contains(application)) {
            throw new RuntimeException("Application already in this group");
        }
        this.getApplications().add(application);
    }

    public void removeApplication(RegisteredApplication application) {
        if (!this.getApplications().contains(application)) {
            throw new RuntimeException("Application not found");
        }
        this.getApplications().remove(application);
    }

    public AnalysisContext clone() {
        AnalysisContext clone = new AnalysisContext(this.migrationProject);
        clone.applications.addAll(this.getApplications());
        clone.generateStaticReports = this.generateStaticReports;
        clone.migrationPath = this.migrationPath;
        clone.advancedOptions.addAll(this.advancedOptions);
        clone.rulesPaths.addAll(this.rulesPaths);
        clone.labelsPaths.addAll(this.labelsPaths);
        clone.includePackages.addAll(this.includePackages);
        clone.excludePackages.addAll(this.excludePackages);
        clone.cloudTargetsIncluded = this.cloudTargetsIncluded;
        clone.linuxTargetsIncluded = this.linuxTargetsIncluded;
        clone.openJdkTargetsIncluded = this.openJdkTargetsIncluded;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalysisContext)) {
            return false;
        }
        AnalysisContext that = (AnalysisContext)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

