/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.util.List;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestReportUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class TestJavaApplicationOverviewUtil
extends TestReportUtil {
    public void checkFilePathEffort(String appSection, String filePath, int effort) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 4]"));
        for (WebElement element : elements) {
            if (element.getText() == null) continue;
            try {
                int number = Integer.parseInt(element.getText());
                if (number == effort) {
                    return;
                }
                throw new CheckFailedException("Found row with appSection: " + appSection + " and filePath: " + filePath + ", but effort was: " + number + " (expected value: " + effort + ")");
            }
            catch (NumberFormatException e) {
            }
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with effort: " + effort);
    }

    public void checkFilePathAndIssues(String appSection, String filePath, String text) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 3]"));
        for (WebElement element : elements) {
            if (element.getText() == null || !element.getText().contains(text)) continue;
            return;
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with issue: " + text);
    }

    public void checkFilePathAndTag(String appSection, String filePath, String tag) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 2]/span"));
        for (WebElement element : elements) {
            if (element.getText() == null || !element.getText().equals(tag)) continue;
            return;
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with tag: " + tag);
    }

    public void checkFilePath(String appSection, String filePath) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
    }

    private WebElement getFileRowElement(String appSection, String filePath) {
        WebElement fileTable = this.getAppSectionElement(appSection).findElement(By.xpath((String)"../../table"));
        WebElement fileRow = fileTable.findElement(By.xpath((String)("./tbody/tr/td/a[normalize-space(text()) = '" + filePath + "']/../..")));
        return fileRow;
    }

    private WebElement getAppSectionElement(String appSection) {
        List titleElements = this.getDriver().findElements(By.className((String)"panel-title"));
        for (WebElement el : titleElements) {
            if (el.getText() == null || !appSection.equals(el.getText().trim())) continue;
            return el;
        }
        return null;
    }
}

