/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.iterables;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.windup.graph.model.WindupVertexFrame;

public class FramesSetIterator<T extends WindupVertexFrame>
implements Iterator<T> {
    private final Iterator<T> wrappedIterator;
    private Set<String> ids = new HashSet<String>();
    private T nextFrame = null;

    public FramesSetIterator(Iterator<T> wrappedIterator) {
        this.wrappedIterator = wrappedIterator;
        this.fillInNextFrame();
    }

    @Override
    public boolean hasNext() {
        return this.nextFrame != null;
    }

    @Override
    public T next() {
        T nextFrame = this.getAndSetNewFrame();
        if (nextFrame == null) {
            throw new NoSuchElementException();
        }
        return nextFrame;
    }

    private T getAndSetNewFrame() {
        T frameToReturn = this.nextFrame;
        this.nextFrame = null;
        this.fillInNextFrame();
        return frameToReturn;
    }

    private void fillInNextFrame() {
        while (this.wrappedIterator.hasNext() && this.nextFrame == null) {
            WindupVertexFrame frame = (WindupVertexFrame)this.wrappedIterator.next();
            String frameId = frame.getElement().id().toString();
            if (this.ids.contains(frameId)) continue;
            this.ids.add(frameId);
            this.nextFrame = frame;
        }
    }

    @Override
    public void remove() {
        this.wrappedIterator.remove();
    }
}

