/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;

public class FileLocationService
extends GraphService<FileLocationModel> {
    private static final String VERTEX_LABEL = "fileLocations";

    public FileLocationService(GraphContext context) {
        super(context, FileLocationModel.class);
    }

    public FileLocationModel getUnique(FileModel fileModel, int columnNumber, int lineNumber, int length, String sourceSnippit) {
        return (FileLocationModel)this.getUnique((Traversal<?, ?>)this.getQuery().getRawTraversal().has("startPosition", (Object)columnNumber).has("lineNumber", (Object)lineNumber).has("length", (Object)length).has("referenceSourceSnippit", (Object)sourceSnippit).as(VERTEX_LABEL, new String[0]).out(new String[]{"file"}).has("filePath", (Object)fileModel.getFilePath()).select(VERTEX_LABEL));
    }

    public FileLocationModel getOrCreate(FileModel fileModel, int columnNumber, int lineNumber, int length, String sourceSnippit) {
        FileLocationModel fileLocationModel = this.getUnique(fileModel, columnNumber, lineNumber, length, sourceSnippit);
        if (fileLocationModel == null) {
            fileLocationModel = (FileLocationModel)this.create();
            fileLocationModel.setFile(fileModel);
            fileLocationModel.setColumnNumber(columnNumber);
            fileLocationModel.setLineNumber(lineNumber);
            fileLocationModel.setLength(length);
            fileLocationModel.setSourceSnippit(sourceSnippit);
        }
        return fileLocationModel;
    }
}

