/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.graph.model.WindupFrame;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

class GraphModelScanner {
    private static final Logger LOG = Logger.getLogger(GraphModelScanner.class.getName());
    private static final String NEWLINE = OperatingSystemUtils.getLineSeparator();

    GraphModelScanner() {
    }

    public static List<Class<? extends WindupFrame<?>>> loadFrames(FurnaceClasspathScanner scanner) {
        ArrayList results = new ArrayList();
        Predicate<String> modelClassFilter = new Predicate<String>(){
            Set<String> skipPackages = new HashSet<String>();
            {
                this.skipPackages.add("org.dom4j.");
                this.skipPackages.add("groovy.model.");
                this.skipPackages.add("com.sleepycat.persist.");
                this.skipPackages.add("org.apache.lucene.");
                this.skipPackages.add("org.openrdf.model.");
                this.skipPackages.add("org.apache.bcel.");
                this.skipPackages.add("org.eclipse.jdt.");
                this.skipPackages.add("org.eclipse.jface.");
                this.skipPackages.add("javax.");
                this.skipPackages.add("org.jboss.weld.");
                this.skipPackages.add("freemarker.");
            }

            public boolean accept(String path) {
                if (!path.endsWith("Model.class")) {
                    return false;
                }
                String clsName = PathUtil.classFilePathToClassname((String)path);
                for (String pkg : this.skipPackages) {
                    if (!clsName.startsWith(pkg)) continue;
                    return false;
                }
                return true;
            }
        };
        LOG.info("Looking for *Model classes...");
        List classes = scanner.scanClasses((Predicate)modelClassFilter);
        for (Class clazz : classes) {
            if (WindupFrame.class.isAssignableFrom(clazz)) {
                LOG.fine("    Found: " + clazz);
                Class windupVertexFrame = clazz;
                results.add(windupVertexFrame);
                continue;
            }
            LOG.fine("    Not adding [" + clazz.getCanonicalName() + "] to GraphTypeRegistry");
        }
        GraphModelScanner.logLoadedModelTypes(results);
        return results;
    }

    private static void logLoadedModelTypes(List<Class<? extends WindupFrame<?>>> types) {
        ArrayList list = new ArrayList(types);
        Collections.sort(list, new Comparator<Class<? extends WindupFrame<?>>>(){

            @Override
            public int compare(Class<? extends WindupFrame<?>> left, Class<? extends WindupFrame<?>> right) {
                if (left == right) {
                    return 0;
                }
                if (left == null) {
                    return 1;
                }
                if (right == null) {
                    return -1;
                }
                return left.getCanonicalName().compareTo(right.getCanonicalName());
            }
        });
        StringBuilder result = new StringBuilder();
        for (Class clazz : list) {
            result.append("\t").append(clazz.getName()).append(NEWLINE);
        }
        LOG.info("Loaded [" + list.size() + "] WindupFrame sub-types [" + NEWLINE + result.toString() + "]");
    }
}

