/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.ElementFrame;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.frames.FrameBooleanDefaultValue;
import org.jboss.windup.graph.model.WindupFrame;

public class DefaultValueInitializer
implements ClassInitializer {
    private Map<Class<?>, LinkedList<PropertyDefaultValue>> cachedValues = new HashMap();

    public Class getInitializationType() {
        return WindupFrame.class;
    }

    public void initalize(Object frame) {
        Class<?> kind = frame.getClass();
        ElementFrame elementFrame = (ElementFrame)frame;
        if (!this.cachedValues.containsKey(kind)) {
            this.cacheFrameInterface(kind, kind);
        }
        this.setupDefaults(elementFrame.getElement(), this.cachedValues.get(kind));
    }

    private void cacheFrameInterface(Class<?> originalKind, Class<?> kind) {
        if (kind == null) {
            return;
        }
        this.cacheFrameInterface(originalKind, kind.getSuperclass());
        for (Class<?> iface : kind.getInterfaces()) {
            this.cacheFrameInterface(originalKind, iface);
        }
        LinkedList<PropertyDefaultValue> values = this.cachedValues.get(originalKind);
        if (values == null) {
            values = new LinkedList();
        }
        for (Method m : kind.getMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = m.getAnnotations()) {
                if (!(annotation instanceof FrameBooleanDefaultValue)) continue;
                PropertyDefaultValue pDefault = new PropertyDefaultValue();
                pDefault.value = ((FrameBooleanDefaultValue)annotation).value();
                pDefault.key = m.getAnnotation(Property.class).value();
                values.add(pDefault);
            }
        }
        this.cachedValues.put(originalKind, values);
    }

    private void setupDefaults(Element element, LinkedList<PropertyDefaultValue> values) {
        for (PropertyDefaultValue pValue : values) {
            element.property(pValue.key, pValue.value);
        }
    }

    private class PropertyDefaultValue {
        private String key;
        private Object value;

        private PropertyDefaultValue() {
        }
    }
}

