/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.VertexFrame;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.InMemoryVertexFrame;
import org.jboss.windup.util.exception.WindupException;

public class FramedElementInMemory<T extends VertexFrame>
implements InvocationHandler {
    private final Class<T> type;
    private final Object id;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private static final Method attachMethod;
    private static final Method asVertexMethod;
    private static final Method hashCodeMethod;
    private static final Method equalsMethod;
    private static final Method toStringMethod;

    public FramedElementInMemory(Class<T> type) {
        this(type, null);
    }

    public FramedElementInMemory(Class<T> type, Object id) {
        this.type = type;
        this.id = id;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) {
        String propertyName;
        String methodName = method.getName();
        if (method.equals(hashCodeMethod)) {
            return this.hashCode();
        }
        if (method.equals(equalsMethod)) {
            return this.equals(arguments[0]);
        }
        if (method.equals(toStringMethod)) {
            return this.toString();
        }
        if (method.equals(attachMethod)) {
            this.attach((GraphContext)arguments[0]);
            return null;
        }
        if (method.equals(asVertexMethod)) {
            return this.asVertex();
        }
        Property propertyAnnotation = method.getAnnotation(Property.class);
        if (propertyAnnotation == null) {
            Property windupPropertyAnnnotation = method.getAnnotation(Property.class);
            if (windupPropertyAnnnotation == null) {
                if (ClassUtilities.isGetMethod((Method)method)) {
                    Method setMethod = ClassUtilities.getSetterMethodForGetter((Method)method);
                    windupPropertyAnnnotation = setMethod.getAnnotation(Property.class);
                } else if (ClassUtilities.isSetMethod((Method)method)) {
                    Method getMethod = ClassUtilities.getGetterMethodForSetter((Method)method);
                    windupPropertyAnnnotation = getMethod.getAnnotation(Property.class);
                }
                if (windupPropertyAnnnotation == null) {
                    throw new WindupException("Method " + methodName + " called, but has no @Property annotation... only @Property methods are supported");
                }
                propertyName = windupPropertyAnnnotation.value();
            } else {
                propertyName = windupPropertyAnnnotation.value();
            }
        } else {
            propertyName = propertyAnnotation.value();
        }
        if (ClassUtilities.isGetMethod((Method)method)) {
            return this.values.get(propertyName);
        }
        if (ClassUtilities.isSetMethod((Method)method)) {
            Object value = arguments[0];
            if (value == null) {
                this.values.remove(propertyName);
            } else {
                this.values.put(propertyName, value);
            }
            return proxy;
        }
        if (ClassUtilities.isRemoveMethod((Method)method)) {
            this.values.remove(propertyName);
            return proxy;
        }
        throw new WindupException("Unrecognized method " + methodName + " called on in-memory Frame!");
    }

    private void attach(GraphContext context) {
        VertexFrame element = (VertexFrame)context.getFramed().addVertex(null, this.type);
        Vertex v = element.asVertex();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            v.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Vertex asVertex() {
        return new Vertex(){

            public Iterable<Edge> getEdges(Direction direction, String ... labels) {
                throw new RuntimeException("Method not supported for FramedElementInMemory");
            }

            public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
                throw new RuntimeException("Method not supported for FramedElementInMemory");
            }

            public VertexQuery query() {
                throw new RuntimeException("Method not supported for FramedElementInMemory");
            }

            public Edge addEdge(String label, Vertex inVertex) {
                throw new RuntimeException("Method not supported for FramedElementInMemory");
            }

            public <T> T getProperty(String key) {
                return (T)FramedElementInMemory.this.values.get(key);
            }

            public Set<String> getPropertyKeys() {
                return FramedElementInMemory.this.values.keySet();
            }

            public void setProperty(String key, Object value) {
                FramedElementInMemory.this.values.put(key, value);
            }

            public <T> T removeProperty(String key) {
                return (T)FramedElementInMemory.this.values.remove(key);
            }

            public void remove() {
                throw new RuntimeException("Method not supported for FramedElementInMemory");
            }

            public Object getId() {
                return FramedElementInMemory.this.id;
            }
        };
    }

    public String toString() {
        return "[Proxy for: " + this.type.getCanonicalName() + ", values: " + this.values + "]";
    }

    static {
        try {
            attachMethod = InMemoryVertexFrame.class.getMethod("attachToGraph", GraphContext.class);
            asVertexMethod = VertexFrame.class.getMethod("asVertex", new Class[0]);
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new WindupException(e.getMessage(), (Throwable)e);
        }
    }
}

