/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.StringTokenizer;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;

public class ArchiveService
extends GraphService<ArchiveModel> {
    public ArchiveService(GraphContext context) {
        super(context, ArchiveModel.class);
    }

    public Iterable<ArchiveModel> findBySHA1(String sha1) {
        GremlinPipeline query = new GremlinPipeline(this.getGraphContext().getGraph());
        query.V();
        query.has("sha1Hash", (Object)sha1);
        query.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ArchiveModel:");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)query, ArchiveModel.class);
    }

    public FileModel getChildFile(ArchiveModel archiveModel, String filePath) {
        StringTokenizer stk = new StringTokenizer(filePath, "/");
        FileModel currentFileModel = archiveModel.getUnzippedDirectory();
        while (stk.hasMoreTokens() && currentFileModel != null) {
            String pathElement = stk.nextToken();
            currentFileModel = this.findFileModel(currentFileModel, pathElement);
        }
        return currentFileModel;
    }

    private FileModel findFileModel(FileModel fm, String pathElement) {
        FileModel result = null;
        for (FileModel child : fm.getFilesInDirectory()) {
            if (!child.getFileName().equals(pathElement)) continue;
            result = child;
            break;
        }
        return result;
    }
}

