/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model.resource;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.ResourceModel;

@TypeValue(value="FileResource")
public interface FileModel
extends ResourceModel {
    public static final String TYPE = "FileResource";
    public static final String ARCHIVE_FILES = "archiveFiles";
    public static final String PARENT_FILE = "parentFile";
    public static final String SHA1_HASH = "sha1Hash";
    public static final String MD5_HASH = "md5Hash";
    public static final String FILE_TO_PROJECT_MODEL = "fileToProjectModel";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_PATH = "filePath";
    public static final String IS_DIRECTORY = "isDirectory";
    public static final String PRETTY_PATH = "fileModelPrettyPath";
    public static final String PRETTY_PATH_WITHIN_PROJECT = "fileModelPrettyPathWithinProject";

    @Property(value="fileName")
    public String getFileName();

    @Indexed
    @Property(value="fileName")
    public void setFileName(String var1);

    @Indexed
    @Property(value="filePath")
    public String getFilePath();

    @JavaHandler
    public void setFilePath(String var1);

    @Property(value="isDirectory")
    public boolean isDirectory();

    @Property(value="md5Hash")
    public String getMD5Hash();

    @Property(value="md5Hash")
    public void setMD5Hash(String var1);

    @Property(value="sha1Hash")
    public String getSHA1Hash();

    @Property(value="sha1Hash")
    public void setSHA1Hash(String var1);

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public FileModel getParentFile();

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public void setParentFile(FileModel var1);

    @Adjacency(label="parentFile", direction=Direction.IN)
    public Iterable<FileModel> getFilesInDirectory();

    @Adjacency(label="parentFile", direction=Direction.IN)
    public void addFileToDirectory(FileModel var1);

    @Adjacency(label="archiveFiles", direction=Direction.IN)
    public ArchiveModel getParentArchive();

    @Adjacency(label="archiveFiles", direction=Direction.IN)
    public void setParentArchive(ArchiveModel var1);

    @Adjacency(label="fileToProjectModel", direction=Direction.OUT)
    public ProjectModel getProjectModel();

    @Adjacency(label="fileToProjectModel", direction=Direction.OUT)
    public void setProjectModel(ProjectModel var1);

    @Override
    @JavaHandler
    public File asFile() throws RuntimeException;

    @Override
    @JavaHandler
    public InputStream asInputStream() throws RuntimeException;

    @JavaHandler
    public String getPrettyPath();

    @JavaHandler
    public String getPrettyPathWithinProject();

    public static abstract class Impl
    implements FileModel,
    JavaHandlerContext<Vertex> {
        @Override
        public String getPrettyPathWithinProject() {
            String result;
            if (((Vertex)this.it()).getProperty(FileModel.PRETTY_PATH_WITHIN_PROJECT) != null) {
                return (String)((Vertex)this.it()).getProperty(FileModel.PRETTY_PATH_WITHIN_PROJECT);
            }
            ProjectModel projectModel = this.getProjectModel();
            if (projectModel == null) {
                result = this.getPrettyPath();
            } else if (projectModel.getRootFileModel().getFilePath().equals(this.getFilePath())) {
                result = "";
            } else {
                String parentPrettyPath;
                String filename = this.getFileName();
                result = this.getParentFile() == null ? (this.getParentArchive() != null ? this.getParentArchive().getPrettyPathWithinProject() : filename) : (StringUtils.isEmpty((String)(parentPrettyPath = this.getParentFile().getPrettyPathWithinProject())) ? filename : parentPrettyPath + "/" + filename);
            }
            ((Vertex)this.it()).setProperty(FileModel.PRETTY_PATH_WITHIN_PROJECT, (Object)result);
            return result;
        }

        @Override
        public String getPrettyPath() {
            if (((Vertex)this.it()).getProperty(FileModel.PRETTY_PATH) != null) {
                return (String)((Vertex)this.it()).getProperty(FileModel.PRETTY_PATH);
            }
            String filename = this.getFileName();
            String result = this.getParentFile() == null ? (this.getParentArchive() != null ? this.getParentArchive().getPrettyPath() : filename) : this.getParentFile().getPrettyPath() + "/" + filename;
            ((Vertex)this.it()).setProperty(FileModel.PRETTY_PATH, (Object)result);
            return result;
        }

        @Override
        public void setFilePath(String filePath) {
            File file = new File(filePath);
            ((Vertex)this.it()).setProperty(FileModel.IS_DIRECTORY, (Object)file.isDirectory());
            ((Vertex)this.it()).setProperty(FileModel.FILE_PATH, (Object)file.getAbsolutePath());
            ((Vertex)this.it()).setProperty(FileModel.FILE_NAME, (Object)file.getName());
        }

        @Override
        public InputStream asInputStream() throws RuntimeException {
            try {
                if (this.getFilePath() == null) {
                    return null;
                }
                File file = new File(this.getFilePath());
                return new FileInputStream(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reading resource.", e);
            }
        }

        @Override
        public File asFile() throws RuntimeException {
            if (this.getFilePath() == null) {
                return null;
            }
            return new File(this.getFilePath());
        }
    }
}

