/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.core;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.structures.FramedEdgeIterable;
import com.tinkerpop.frames.structures.FramedVertexIterable;

public class FramedGraphQueryImpl
implements FramedGraphQuery {
    private GraphQuery graphQuery;
    private FramedGraph<?> graph;

    public FramedGraphQueryImpl(FramedGraph<?> graph, GraphQuery graphQuery) {
        this.graph = graph;
        this.graphQuery = graphQuery;
    }

    @Override
    public FramedGraphQuery has(String key) {
        this.graphQuery = this.graphQuery.has(key);
        return this;
    }

    @Override
    public FramedGraphQuery hasNot(String key) {
        this.graphQuery = this.graphQuery.hasNot(key);
        return this;
    }

    @Override
    public FramedGraphQuery has(String key, Object value) {
        this.graphQuery = this.graphQuery.has(key, value);
        return this;
    }

    @Override
    public FramedGraphQuery hasNot(String key, Object value) {
        this.graphQuery = this.graphQuery.hasNot(key, value);
        return this;
    }

    @Override
    public FramedGraphQuery has(String key, Predicate predicate, Object value) {
        this.graphQuery = this.graphQuery.has(key, predicate, value);
        return this;
    }

    @Override
    public <T extends Comparable<T>> FramedGraphQuery has(String key, T value, Query.Compare compare) {
        this.graphQuery = this.graphQuery.has(key, value, compare);
        return this;
    }

    @Override
    public <T extends Comparable<?>> FramedGraphQuery interval(String key, T startValue, T endValue) {
        this.graphQuery = this.graphQuery.interval(key, startValue, endValue);
        return this;
    }

    @Override
    public FramedGraphQuery limit(int limit) {
        this.graphQuery = this.graphQuery.limit(limit);
        return this;
    }

    @Override
    public <T> Iterable<T> edges(Class<T> kind) {
        return new FramedEdgeIterable<T>(this.graph, this.edges(), kind);
    }

    @Override
    public <T> Iterable<T> vertices(Class<T> kind) {
        return new FramedVertexIterable<T>(this.graph, this.vertices(), kind);
    }

    public Iterable<Edge> edges() {
        return this.graphQuery.edges();
    }

    public Iterable<Vertex> vertices() {
        return this.graphQuery.vertices();
    }
}

