/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.builder.AnnotatedTypeConfigurator;
import org.jboss.weld.bootstrap.events.builder.AnnotatedConfigurator;
import org.jboss.weld.bootstrap.events.builder.AnnotatedConstructorConfiguratorImpl;
import org.jboss.weld.bootstrap.events.builder.AnnotatedFieldConfiguratorImpl;
import org.jboss.weld.bootstrap.events.builder.AnnotatedMethodConfiguratorImpl;
import org.jboss.weld.bootstrap.events.builder.AnnotatedParameterConfiguratorImpl;
import org.jboss.weld.bootstrap.events.builder.AnnotatedTypeConfiguratorImpl;
import org.jboss.weld.util.annotated.ForwardingAnnotatedConstructor;
import org.jboss.weld.util.annotated.ForwardingAnnotatedField;
import org.jboss.weld.util.annotated.ForwardingAnnotatedMethod;
import org.jboss.weld.util.annotated.ForwardingAnnotatedParameter;
import org.jboss.weld.util.annotated.ForwardingAnnotatedType;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;

public class AnnotatedTypeBuilderImpl<T> {
    private final AnnotatedTypeConfiguratorImpl<T> configurator;

    public AnnotatedTypeBuilderImpl(AnnotatedTypeConfiguratorImpl<T> configurator) {
        this.configurator = configurator;
    }

    public AnnotatedTypeConfigurator<T> configure() {
        return this.configurator;
    }

    public AnnotatedType<T> build() {
        return new AnnotatedTypeImpl<T>(this.configurator);
    }

    private static class Annotations {
        private final Set<Annotation> annotations;
        private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

        private Annotations(AnnotatedConfigurator<?, ?, ?> configurator) {
            this.annotations = ImmutableSet.copyOf(configurator.getAnnotations());
            this.annotationsMap = (Map)this.annotations.stream().collect(ImmutableMap.collector(a -> a.annotationType(), Function.identity()));
        }

        Set<Annotation> get() {
            return this.annotations;
        }

        boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationsMap.containsKey(annotationType);
        }

        <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)this.annotationsMap.get(annotationType);
        }
    }

    static class AnnotatedParameterImpl<X>
    extends ForwardingAnnotatedParameter<X> {
        private final Annotations annotations;
        private final AnnotatedParameter<X> delegate;

        public AnnotatedParameterImpl(AnnotatedParameterConfiguratorImpl<X> configurator) {
            this.delegate = (AnnotatedParameter)configurator.getAnnotated();
            this.annotations = new Annotations(configurator);
        }

        @Override
        protected AnnotatedParameter<X> delegate() {
            return this.delegate;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return this.annotations.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations.get();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.isAnnotationPresent(annotationType);
        }
    }

    static class AnnotatedConstructorImpl<X>
    extends ForwardingAnnotatedConstructor<X> {
        private final Annotations annotations;
        private final AnnotatedConstructor<X> delegate;
        private final List<AnnotatedParameter<X>> parameters;

        AnnotatedConstructorImpl(AnnotatedConstructorConfiguratorImpl<X> configurator) {
            this.delegate = (AnnotatedConstructor)configurator.getAnnotated();
            this.annotations = new Annotations(configurator);
            this.parameters = (List)configurator.getParams().stream().map(c -> new AnnotatedParameterImpl(c)).collect(ImmutableList.collector());
        }

        @Override
        public AnnotatedConstructor<X> delegate() {
            return this.delegate;
        }

        @Override
        public List<AnnotatedParameter<X>> getParameters() {
            return this.parameters;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return this.annotations.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations.get();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.isAnnotationPresent(annotationType);
        }
    }

    static class AnnotatedFieldImpl<X>
    extends ForwardingAnnotatedField<X> {
        private final Annotations annotations;
        private final AnnotatedField<X> delegate;

        AnnotatedFieldImpl(AnnotatedFieldConfiguratorImpl<X> configurator) {
            this.delegate = (AnnotatedField)configurator.getAnnotated();
            this.annotations = new Annotations(configurator);
        }

        @Override
        public AnnotatedField<X> delegate() {
            return this.delegate;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return this.annotations.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations.get();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.isAnnotationPresent(annotationType);
        }
    }

    static class AnnotatedMethodImpl<X>
    extends ForwardingAnnotatedMethod<X> {
        private final Annotations annotations;
        private final AnnotatedMethod<X> delegate;
        private final List<AnnotatedParameter<X>> parameters;

        AnnotatedMethodImpl(AnnotatedMethodConfiguratorImpl<X> configurator) {
            this.delegate = (AnnotatedMethod)configurator.getAnnotated();
            this.annotations = new Annotations(configurator);
            this.parameters = (List)configurator.getParams().stream().map(c -> new AnnotatedParameterImpl(c)).collect(ImmutableList.collector());
        }

        @Override
        public AnnotatedMethod<X> delegate() {
            return this.delegate;
        }

        @Override
        public List<AnnotatedParameter<X>> getParameters() {
            return this.parameters;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return this.annotations.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations.get();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.isAnnotationPresent(annotationType);
        }
    }

    static class AnnotatedTypeImpl<X>
    extends ForwardingAnnotatedType<X> {
        private final Annotations annotations;
        private final AnnotatedType<X> delegate;
        private final Set<AnnotatedMethod<? super X>> methods;
        private final Set<AnnotatedField<? super X>> fields;
        private final Set<AnnotatedConstructor<X>> constructors;

        public AnnotatedTypeImpl(AnnotatedTypeConfiguratorImpl<X> configurator) {
            this.delegate = (AnnotatedType)configurator.getAnnotated();
            this.annotations = new Annotations(configurator);
            this.methods = (Set)configurator.getMethods().stream().map(m -> new AnnotatedMethodImpl(m)).collect(ImmutableSet.collector());
            this.fields = (Set)configurator.getFields().stream().map(f -> new AnnotatedFieldImpl(f)).collect(ImmutableSet.collector());
            this.constructors = (Set)configurator.getConstructors().stream().map(c -> new AnnotatedConstructorImpl(c)).collect(ImmutableSet.collector());
        }

        @Override
        public AnnotatedType<X> delegate() {
            return this.delegate;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return this.annotations.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations.get();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.isAnnotationPresent(annotationType);
        }

        @Override
        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.methods;
        }

        @Override
        public Set<AnnotatedField<? super X>> getFields() {
            return this.fields;
        }

        @Override
        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.constructors;
        }
    }
}

