/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.builder.BeanAttributesConfigurator;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.builder.BeanAttributesBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.BeanAttributesConfiguratorImpl;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ProcessBeanAttributesImpl<T>
extends AbstractDefinitionContainerEvent
implements ProcessBeanAttributes<T> {
    private final Annotated annotated;
    private BeanAttributes<T> attributes;
    private BeanAttributesConfiguratorImpl<T> configurator;
    private boolean veto;
    private boolean dirty;
    private boolean beanAttributesSet;

    protected static <T> ProcessBeanAttributesImpl<T> fire(BeanManagerImpl beanManager, BeanAttributes<T> attributes, Annotated annotated, Type type) {
        ProcessBeanAttributesImpl event = new ProcessBeanAttributesImpl<T>(beanManager, (BeanAttributes)attributes, annotated, type){};
        event.fire();
        return event;
    }

    private ProcessBeanAttributesImpl(BeanManagerImpl beanManager, BeanAttributes<T> attributes, Annotated annotated, Type type) {
        super(beanManager, (Type)((Object)ProcessBeanAttributes.class), new Type[]{type});
        this.attributes = attributes;
        this.annotated = annotated;
    }

    public Annotated getAnnotated() {
        this.checkWithinObserverNotification();
        return this.annotated;
    }

    public BeanAttributes<T> getBeanAttributes() {
        this.checkWithinObserverNotification();
        return this.attributes;
    }

    public BeanAttributes<T> getBeanAttributesInternal() {
        return this.attributes;
    }

    public void setBeanAttributes(BeanAttributes<T> beanAttributes) {
        if (this.configurator != null) {
            throw new IllegalStateException("Configurator used");
        }
        this.checkWithinObserverNotification();
        BootstrapLogger.LOG.setBeanAttributesCalled(this.getReceiver(), this.attributes, beanAttributes);
        this.attributes = beanAttributes;
        this.dirty = true;
        this.beanAttributesSet = true;
    }

    public BeanAttributesConfigurator<T> configureBeanAttributes() {
        if (this.beanAttributesSet) {
            throw new IllegalStateException("setAnnotatedType() used");
        }
        this.checkWithinObserverNotification();
        if (this.configurator == null) {
            this.configurator = new BeanAttributesConfiguratorImpl<T>(this.attributes);
        }
        return this.configurator;
    }

    public void veto() {
        this.checkWithinObserverNotification();
        this.veto = true;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void postNotify(Extension extension) {
        super.postNotify(extension);
        if (this.configurator != null) {
            this.attributes = new BeanAttributesBuilderImpl<T>(this.configurator).build();
            this.configurator = null;
            this.dirty = true;
        }
        this.beanAttributesSet = false;
    }
}

