/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Iterators;

abstract class ImmutableTinyList<E>
extends ImmutableList<E>
implements RandomAccess {
    ImmutableTinyList() {
    }

    static class Singleton<E>
    extends ImmutableTinyList<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final E element;

        Singleton(E element) {
            this.element = element;
        }

        @Override
        public int indexOf(Object o) {
            if (o != null && o.equals(this.element)) {
                return 0;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index == 0 || index == 1) {
                return new SingletonIterator(index);
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException(String.valueOf(fromIndex));
            }
            if (toIndex > this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(toIndex));
            }
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return this;
        }

        @Override
        public int hashCode() {
            return 31 + this.element.hashCode();
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public int size() {
            return 1;
        }

        private class SingletonIterator
        extends Iterators.IndexIterator<E> {
            SingletonIterator(int index) {
                super(Singleton.this.size(), index);
            }

            @Override
            E getElement(int index) {
                return Singleton.this.element;
            }
        }
    }
}

