/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jta;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.jta.DeferredEventNotification;
import org.jboss.weld.jta.Status;
import org.jboss.weld.jta.TransactionNotificationSynchronization;
import org.jboss.weld.module.ObserverNotifierFactory;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.transaction.spi.TransactionServices;

class TransactionalObserverNotifier
extends ObserverNotifier {
    static final ObserverNotifierFactory FACTORY = new ObserverNotifierFactory(){

        @Override
        public ObserverNotifier create(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
            return new TransactionalObserverNotifier(contextId, resolver, services, strict);
        }
    };
    private final TransactionServices transactionServices;
    private final String contextId;

    TransactionalObserverNotifier(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        super(contextId, resolver, services, strict);
        this.contextId = contextId;
        this.transactionServices = services.get(TransactionServices.class);
    }

    private <T> void deferNotification(T event, EventMetadata metadata, ObserverMethod<? super T> observer, List<DeferredEventNotification<?>> notifications) {
        TransactionPhase transactionPhase = observer.getTransactionPhase();
        boolean before = transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION);
        Status status = Status.valueOf(transactionPhase);
        notifications.add(new DeferredEventNotification<T>(this.contextId, event, metadata, observer, this.currentEventMetadata, status, before));
    }

    @Override
    protected <T> void notifyTransactionObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata, ObserverNotifier.ObserverExceptionHandler handler) {
        if (observers.isEmpty()) {
            return;
        }
        if (this.transactionServices == null || !this.transactionServices.isTransactionActive()) {
            this.notifySyncObservers(observers, event, metadata, handler);
        } else {
            ArrayList notifications = new ArrayList();
            for (ObserverMethod observerMethod : observers) {
                this.deferNotification(event, metadata, observerMethod, notifications);
            }
            this.transactionServices.registerSynchronization(new TransactionNotificationSynchronization(notifications));
        }
    }
}

