/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bootstrap.BeanDeploymentFinder;
import org.jboss.weld.bootstrap.events.BeanAttributesBuilder;
import org.jboss.weld.experimental.BeanBuilder;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public final class BeanBuilderImpl<T>
extends BeanAttributesBuilder<T, BeanBuilder<T>>
implements BeanBuilder<T> {
    private static final String ARG_CALLBACK = "callback";
    private static final String ARG_ID = "id";
    private static final String ARG_INJECTION_POINTS = "injectionPoints";
    private static final String ARG_INJECTION_POINT = "injectionPoint";
    private static final String ARG_BEAN_CLASS = "beanClass";
    private static final String ARG_BEAN_ATTRS = "beanAttributes";
    private static final String ARG_ANN_TYPE = "annotatedType";
    private final Class<?> defaultBeanClass;
    private final Set<InjectionPoint> injectionPoints;
    private BeanDeploymentFinder beanDeploymentFinder;
    private BeanManagerImpl beanManager;
    private Class<?> beanClass;
    private String id;
    private CreateCallback<T> createCallback;
    private DestroyCallback<T> destroyCallback;
    private AnnotatedType<? extends T> annotatedType;

    public BeanBuilderImpl(Class<?> defaultBeanClass, BeanDeploymentFinder beanDeploymentFinder) {
        this.defaultBeanClass = defaultBeanClass;
        this.beanDeploymentFinder = beanDeploymentFinder;
        this.injectionPoints = new HashSet<InjectionPoint>();
    }

    public BeanBuilderImpl(Class<?> defaultBeanClass) {
        this(defaultBeanClass, null);
    }

    @Override
    public Bean<T> build() {
        Class<?> finalBeanClass;
        if (this.annotatedType != null) {
            this.readAnnotatedTypeBeanClass(this.annotatedType);
        }
        Class<?> clazz = finalBeanClass = this.beanClass != null ? this.beanClass : this.defaultBeanClass;
        if (this.beanDeploymentFinder != null) {
            this.beanManager = this.beanDeploymentFinder.getOrCreateBeanDeployment(finalBeanClass).getBeanManager();
            if (this.annotatedType != null) {
                this.readAnnotatedType(this.annotatedType);
            }
        }
        this.validate();
        return new ImmutableBean(this.beanManager, this.id, this.beanClass == null ? this.defaultBeanClass : this.beanClass, super.build(), this.injectionPoints, this.createCallback, this.destroyCallback);
    }

    @Override
    public <U extends T> BeanBuilder<U> read(AnnotatedType<U> annotatedType) {
        Preconditions.checkArgumentNotNull(annotatedType, ARG_ANN_TYPE);
        this.annotatedType = annotatedType;
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public BeanBuilder<T> read(BeanAttributes<?> beanAttributes) {
        Preconditions.checkArgumentNotNull(beanAttributes, ARG_BEAN_ATTRS);
        this.scope((Class<Annotation>)beanAttributes.getScope());
        this.name(beanAttributes.getName());
        this.alternative(beanAttributes.isAlternative());
        this.qualifiers((Set<Annotation>)beanAttributes.getQualifiers());
        this.stereotypes((Set<Class<Annotation>>)beanAttributes.getStereotypes());
        this.types((Set<Type>)beanAttributes.getTypes());
        return this;
    }

    @Override
    public BeanBuilder<T> beanClass(Class<?> beanClass) {
        Preconditions.checkArgumentNotNull(beanClass, ARG_BEAN_CLASS);
        this.beanClass = beanClass;
        return this;
    }

    @Override
    public BeanBuilder<T> addInjectionPoint(InjectionPoint injectionPoint) {
        Preconditions.checkArgumentNotNull(injectionPoint, ARG_INJECTION_POINT);
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    @Override
    public BeanBuilder<T> addInjectionPoints(InjectionPoint ... injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints, ARG_INJECTION_POINTS);
        Collections.addAll(this.injectionPoints, injectionPoints);
        return this;
    }

    @Override
    public BeanBuilder<T> addInjectionPoints(Set<InjectionPoint> injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints, ARG_INJECTION_POINTS);
        this.injectionPoints.addAll(injectionPoints);
        return this;
    }

    @Override
    public BeanBuilder<T> injectionPoints(InjectionPoint ... injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints, ARG_INJECTION_POINTS);
        this.injectionPoints.clear();
        Collections.addAll(this.injectionPoints, injectionPoints);
        return this;
    }

    @Override
    public BeanBuilder<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        Preconditions.checkArgumentNotNull(injectionPoints, ARG_INJECTION_POINTS);
        this.injectionPoints.clear();
        this.injectionPoints.addAll(injectionPoints);
        return this;
    }

    @Override
    public BeanBuilder<T> id(String id) {
        Preconditions.checkArgumentNotNull(id, ARG_ID);
        this.id = id;
        return this;
    }

    @Override
    public <U extends T> BeanBuilder<U> createWith(Function<CreationalContext<U>, U> callback) {
        Preconditions.checkArgumentNotNull(callback, ARG_CALLBACK);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromCreateWith(callback));
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanBuilder<U> produceWith(Function<Instance<Object>, U> callback) {
        Preconditions.checkArgumentNotNull(callback, ARG_CALLBACK);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        if (this.destroyCallback == null) {
            this.destroyCallback = new DestroyCallback<Object>(i -> {});
        }
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanBuilder<U> produceWith(Supplier<U> callback) {
        Preconditions.checkArgumentNotNull(callback, ARG_CALLBACK);
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        if (this.destroyCallback == null) {
            this.destroyCallback = new DestroyCallback<Object>(i -> {});
        }
        return (BeanBuilder)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanBuilder<U> producing(U instance) {
        return this.produceWith(() -> instance);
    }

    @Override
    public BeanBuilder<T> destroyWith(BiConsumer<T, CreationalContext<T>> callback) {
        Preconditions.checkArgumentNotNull(callback, ARG_CALLBACK);
        this.destroyCallback = new DestroyCallback<T>(callback);
        return this;
    }

    @Override
    public BeanBuilder<T> disposeWith(Consumer<T> callback) {
        Preconditions.checkArgumentNotNull(callback, ARG_CALLBACK);
        this.destroyCallback = new DestroyCallback<T>(callback);
        return this;
    }

    public void setBeanDeploymentFinder(BeanDeploymentFinder beanDeploymentFinder) {
        this.beanDeploymentFinder = beanDeploymentFinder;
    }

    @Override
    protected BeanBuilder<T> self() {
        return this;
    }

    @Override
    BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    void validate() {
        if (this.beanManager == null) {
            throw BeanLogger.LOG.beanBuilderInvalidBeanManager(this);
        }
        if (this.createCallback == null) {
            throw BeanLogger.LOG.beanBuilderInvalidCreateCallback(this);
        }
        if (this.destroyCallback == null) {
            throw BeanLogger.LOG.beanBuilderInvalidDestroyCallback(this);
        }
    }

    public String toString() {
        return String.format("BeanBuilderImpl [id=%s, beanClass=%s, qualifiers=%s, types=%s]", this.id, this.beanClass, this.qualifiers, this.types);
    }

    private <U extends T> void readAnnotatedTypeBeanClass(AnnotatedType<U> type) {
        if (this.beanClass == null) {
            this.beanClass(type.getJavaClass());
        }
    }

    private <U extends T> void readAnnotatedType(AnnotatedType<U> type) {
        InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(this.beanManager.getInjectionTargetFactory((AnnotatedType)type).createInjectionTarget((Bean)null));
        this.addInjectionPoints(injectionTarget.getInjectionPoints());
        if (this.createCallback == null) {
            this.createWith(c -> {
                Object instance = injectionTarget.produce(c);
                injectionTarget.inject(instance, c);
                injectionTarget.postConstruct(instance);
                return instance;
            });
        }
        if (this.destroyCallback == null) {
            this.destroyWith((i, c) -> {
                injectionTarget.preDestroy(i);
                c.release();
            });
        }
        BeanAttributes<U> beanAttributes = this.beanManager.createBeanAttributes(type);
        if (this.scope == null && beanAttributes.getScope() != null) {
            this.scope((Class<Annotation>)beanAttributes.getScope());
        }
        if (this.name == null && beanAttributes.getName() != null) {
            this.name(beanAttributes.getName());
        }
        if (this.alternative == null) {
            this.alternative(beanAttributes.isAlternative());
        }
        this.addQualifiers((Set<Annotation>)beanAttributes.getQualifiers());
        this.addStereotypes((Set<Class<Annotation>>)beanAttributes.getStereotypes());
        this.addTypes((Set<Type>)beanAttributes.getTypes());
    }

    static class DestroyCallback<T> {
        private final BiConsumer<T, CreationalContext<T>> destroy;
        private final Consumer<T> simple;

        public DestroyCallback(Consumer<T> callback) {
            this.destroy = null;
            this.simple = callback;
        }

        public DestroyCallback(BiConsumer<T, CreationalContext<T>> callback) {
            this.destroy = callback;
            this.simple = null;
        }

        void destroy(T instance, CreationalContext<T> ctx) {
            if (this.simple != null) {
                this.simple.accept(instance);
            } else {
                this.destroy.accept(instance, ctx);
            }
        }
    }

    static class CreateCallback<T> {
        private final Supplier<T> simple;
        private final Function<CreationalContext<T>, T> create;
        private final Function<Instance<Object>, T> instance;

        static <T> CreateCallback<T> fromProduceWith(Function<Instance<Object>, T> callback) {
            return new CreateCallback<T>(null, null, callback);
        }

        static <T> CreateCallback<T> fromProduceWith(Supplier<T> callback) {
            return new CreateCallback<T>(callback, null, null);
        }

        static <T> CreateCallback<T> fromCreateWith(Function<CreationalContext<T>, T> callback) {
            return new CreateCallback<T>(null, callback, null);
        }

        public CreateCallback(Supplier<T> simple, Function<CreationalContext<T>, T> create, Function<Instance<Object>, T> instance) {
            this.simple = simple;
            this.create = create;
            this.instance = instance;
        }

        T create(CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.simple != null) {
                return this.simple.get();
            }
            if (this.instance != null) {
                return this.instance.apply(beanManager.getInstance(ctx));
            }
            return this.create.apply(ctx);
        }
    }

    static class ImmutableBean<T>
    extends ForwardingBeanAttributes<T>
    implements Bean<T>,
    PassivationCapable {
        private final String id;
        private final BeanManagerImpl beanManager;
        private final Class<?> beanClass;
        private final BeanAttributes<T> attributes;
        private final Set<InjectionPoint> injectionPoints;
        private final CreateCallback<T> createCallback;
        private final DestroyCallback<T> destroyCallback;

        ImmutableBean(BeanManagerImpl beanManager, String id, Class<?> beanClass, BeanAttributes<T> attributes, Set<InjectionPoint> injectionPoints, CreateCallback<T> createCallback, DestroyCallback<T> destroyCallback) {
            this.beanManager = beanManager;
            this.beanClass = beanClass;
            this.attributes = attributes;
            this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
            this.createCallback = createCallback;
            this.destroyCallback = destroyCallback;
            this.id = id != null ? id : BeanIdentifiers.forBuilderBean(attributes, beanClass);
        }

        public T create(CreationalContext<T> creationalContext) {
            return this.createCallback.create(creationalContext, this.beanManager);
        }

        public void destroy(T instance, CreationalContext<T> creationalContext) {
            this.destroyCallback.destroy(instance, creationalContext);
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public boolean isNullable() {
            return false;
        }

        @Override
        protected BeanAttributes<T> attributes() {
            return this.attributes;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "Immutable Builder Bean [" + this.getBeanClass().toString() + "] with types [" + Formats.formatTypes(this.getTypes()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]";
        }
    }
}

