/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.events.AbstractBeanBuilder;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

abstract class BeanAttributesBuilder<T, B>
extends AbstractBeanBuilder {
    static final Set<Annotation> DEFAULT_QUALIFIERS = ImmutableSet.of(new Annotation[]{AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE});
    protected static final String ARG_SCOPE = "scope";
    protected static final String ARG_NAME = "name";
    protected static final String ARG_TYPES = "types";
    protected static final String ARG_TYPE = "type";
    protected static final String ARG_TYPE_LITERAL = "typeLiteral";
    protected static final String ARG_QUALIFIERS = "qualifiers";
    protected static final String ARG_QUALIFIER = "qualifier";
    protected static final String ARG_STEREOTYPES = "stereotypes";
    protected static final String ARG_STEREOTYPE = "stereotype";
    protected String name;
    protected Set<Annotation> qualifiers = new HashSet<Annotation>();
    protected Class<? extends Annotation> scope;
    protected Set<Class<? extends Annotation>> stereotypes;
    protected Set<Type> types = new HashSet<Type>();
    protected Boolean alternative;

    BeanAttributesBuilder() {
        this.types.add((Type)((Object)Object.class));
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
    }

    BeanAttributes<T> build() {
        return new ImmutableBeanAttributes(ImmutableSet.copyOf(this.stereotypes), this.alternative != null ? this.alternative : false, this.name, this.initQualifiers(), ImmutableSet.copyOf(this.types), this.scope != null ? this.scope : Dependent.class);
    }

    public B addType(Type type) {
        Preconditions.checkArgumentNotNull(type, ARG_TYPE);
        this.types.add(type);
        return this.self();
    }

    public B addType(TypeLiteral<?> typeLiteral) {
        Preconditions.checkArgumentNotNull(typeLiteral, ARG_TYPE_LITERAL);
        this.types.add(typeLiteral.getType());
        return this.self();
    }

    public B addTypes(Type ... types) {
        Preconditions.checkArgumentNotNull(types, ARG_TYPES);
        Collections.addAll(this.types, types);
        return this.self();
    }

    public B addTypes(Set<Type> types) {
        Preconditions.checkArgumentNotNull(types, ARG_TYPES);
        this.types.addAll(types);
        return this.self();
    }

    public B addTransitiveTypeClosure(Type type) {
        Preconditions.checkArgumentNotNull(type, ARG_TYPE);
        this.types.addAll(Beans.getLegalBeanTypes(new HierarchyDiscovery(type).getTypeClosure(), type, new Type[0]));
        return this.self();
    }

    public B types(Type ... types) {
        Preconditions.checkArgumentNotNull(types, ARG_TYPES);
        this.types.clear();
        Collections.addAll(this.types, types);
        return this.self();
    }

    public B types(Set<Type> types) {
        Preconditions.checkArgumentNotNull(types, ARG_TYPES);
        this.types.clear();
        this.types.addAll(types);
        return this.self();
    }

    public B scope(Class<? extends Annotation> scope) {
        Preconditions.checkArgumentNotNull(scope, ARG_SCOPE);
        this.scope = scope;
        return this.self();
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public B addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier, ARG_QUALIFIER);
        this.qualifiers.add(qualifier);
        return this.self();
    }

    public B addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers, ARG_QUALIFIERS);
        Collections.addAll(this.qualifiers, qualifiers);
        return this.self();
    }

    public B addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers, ARG_QUALIFIERS);
        this.qualifiers.addAll(qualifiers);
        return this.self();
    }

    public B qualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers, ARG_QUALIFIERS);
        this.qualifiers.clear();
        Collections.addAll(this.qualifiers, qualifiers);
        return this.self();
    }

    public B qualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers, ARG_QUALIFIERS);
        this.qualifiers.clear();
        this.qualifiers.addAll(qualifiers);
        return this.self();
    }

    public boolean hasQualifiers() {
        return !this.qualifiers.isEmpty();
    }

    public B addStereotype(Class<? extends Annotation> stereotype) {
        Preconditions.checkArgumentNotNull(stereotype, ARG_STEREOTYPE);
        this.stereotypes.add(stereotype);
        return this.self();
    }

    public B addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        Preconditions.checkArgumentNotNull(stereotypes, ARG_STEREOTYPES);
        this.stereotypes.addAll(stereotypes);
        return this.self();
    }

    public B stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        Preconditions.checkArgumentNotNull(stereotypes, ARG_STEREOTYPES);
        this.stereotypes.clear();
        this.stereotypes.addAll(stereotypes);
        return this.self();
    }

    public B name(String name) {
        Preconditions.checkArgumentNotNull(name, ARG_NAME);
        this.name = name;
        return this.self();
    }

    public B alternative() {
        return this.alternative(true);
    }

    public B alternative(boolean value) {
        this.alternative = value;
        return this.self();
    }

    protected abstract B self();

    protected Set<Annotation> initQualifiers() {
        if (this.qualifiers.isEmpty()) {
            return DEFAULT_QUALIFIERS;
        }
        Set<Annotation> normalized = new HashSet<Annotation>(this.qualifiers);
        normalized.remove(AnyLiteral.INSTANCE);
        normalized.remove(DefaultLiteral.INSTANCE);
        if (normalized.isEmpty()) {
            normalized = DEFAULT_QUALIFIERS;
        } else {
            ImmutableSet.Builder<Object> builder = ImmutableSet.builder();
            if (normalized.size() == 1 && this.qualifiers.iterator().next().annotationType().equals(Named.class)) {
                builder.add(DefaultLiteral.INSTANCE);
            }
            builder.add(AnyLiteral.INSTANCE);
            builder.addAll((Iterable<Object>)this.qualifiers);
            normalized = builder.build();
        }
        return normalized;
    }
}

