/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDecoratorResolver
extends TypeSafeBeanResolver<DecoratorImpl<?>> {
    public TypeSafeDecoratorResolver(BeanManagerImpl manager, Iterable<DecoratorImpl<?>> decorators) {
        super(manager, decorators);
    }

    @Override
    protected boolean matches(Resolvable resolvable, DecoratorImpl<?> bean) {
        return Reflections.matches(bean.getDelegateTypes(), resolvable.getTypeClosure()) && Beans.containsAllBindings(bean.getDelegateQualifiers(), resolvable.getQualifiers(), this.getManager()) && this.getManager().getEnabledDecoratorClasses().contains(bean.getType());
    }

    @Override
    protected Set<DecoratorImpl<?>> sortResult(Set<DecoratorImpl<?>> matchedDecorators) {
        TreeSet sortedBeans = new TreeSet(new Comparator<DecoratorImpl<?>>(){

            @Override
            public int compare(DecoratorImpl<?> o1, DecoratorImpl<?> o2) {
                List<Class<?>> enabledDecorators = TypeSafeDecoratorResolver.this.getManager().getEnabledDecoratorClasses();
                int p1 = enabledDecorators.indexOf(o1.getType());
                int p2 = enabledDecorators.indexOf(o2.getType());
                return p1 - p2;
            }
        });
        sortedBeans.addAll(matchedDecorators);
        return sortedBeans;
    }
}

