/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedResolver {
    private ConcurrentCache<String, Set<Bean<?>>> resolvedNames;
    private final Iterable<? extends Bean<?>> allBeans;
    private final BeanManagerImpl manager;

    public NameBasedResolver(BeanManagerImpl manager, Iterable<? extends Bean<?>> allBeans) {
        this.manager = manager;
        this.allBeans = allBeans;
        this.resolvedNames = new ConcurrentCache();
    }

    public void clear() {
        this.resolvedNames = new ConcurrentCache();
    }

    public Set<Bean<?>> resolve(final String name) {
        return (Set)this.resolvedNames.putIfAbsent(name, new Callable<Set<Bean<?>>>(){

            @Override
            public Set<Bean<? extends Object>> call() throws Exception {
                HashSet<Bean> matchedBeans = new HashSet<Bean>();
                for (Bean bean : NameBasedResolver.this.allBeans) {
                    if ((bean.getName() != null || name != null) && (bean.getName() == null || !bean.getName().equals(name))) continue;
                    matchedBeans.add(bean);
                }
                return Beans.retainEnabledPolicies(matchedBeans, NameBasedResolver.this.manager.getEnabledPolicyClasses(), NameBasedResolver.this.manager.getEnabledPolicyStereotypes());
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }
}

