/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import javax.enterprise.inject.AnnotationLiteral;
import javax.faces.context.FacesContext;
import org.jboss.weld.conversation.ConversationIdName;
import org.jboss.weld.jsf.JsfHelper;

public class FacesUrlTransformer {
    private static final String HTTP_PROTOCOL_URL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_URL_PREFIX = "https://";
    private static final String QUERY_STRING_DELIMITER = "?";
    private static final String PARAMETER_PAIR_DELIMITER = "&";
    private static final String PARAMETER_ASSIGNMENT_OPERATOR = "=";
    private String url;
    private final FacesContext context;

    public FacesUrlTransformer(String url, FacesContext facesContext) {
        this.url = url;
        this.context = facesContext;
    }

    public FacesUrlTransformer appendConversationIdIfNecessary(String cid) {
        String cidParamName = JsfHelper.getModuleBeanManager(this.context).getInstanceByType(String.class, new AnnotationLiteral<ConversationIdName>(){});
        int queryStringIndex = this.url.indexOf(QUERY_STRING_DELIMITER);
        if (queryStringIndex < 0 || this.url.indexOf(cidParamName + PARAMETER_ASSIGNMENT_OPERATOR, queryStringIndex) < 0) {
            this.url = this.url + (queryStringIndex < 0 ? QUERY_STRING_DELIMITER : PARAMETER_PAIR_DELIMITER) + cidParamName + PARAMETER_ASSIGNMENT_OPERATOR + cid;
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public FacesUrlTransformer toRedirectViewId() {
        if (this.isUrlAbsolute()) {
            String requestPath = this.context.getExternalContext().getRequestContextPath();
            this.url = this.url.substring(this.url.indexOf(requestPath) + requestPath.length());
        } else {
            int lastSlash = this.url.lastIndexOf("/");
            if (lastSlash > 0) {
                this.url = this.url.substring(lastSlash);
            }
        }
        return this;
    }

    public FacesUrlTransformer toActionUrl() {
        this.url = this.context.getApplication().getViewHandler().getActionURL(this.context, this.url);
        return this;
    }

    public String encode() {
        return this.context.getExternalContext().encodeActionURL(this.url);
    }

    private boolean isUrlAbsolute() {
        return this.url.startsWith(HTTP_PROTOCOL_URL_PREFIX) || this.url.startsWith(HTTPS_PROTOCOL_URL_PREFIX);
    }
}

