/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.facade;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.TypeLiteral;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.builtin.facade.AbstractFacade;
import org.jboss.weld.resolution.ResolvableWeldClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;
    private static final Annotation[] EMPTY_BINDINGS = new Annotation[0];
    private final transient Set<Bean<?>> beans;

    public static <I> Instance<I> of(Type type, BeanManagerImpl manager, Set<Annotation> annotations) {
        return new InstanceImpl(type, manager, annotations);
    }

    private InstanceImpl(Type type, BeanManagerImpl manager, Set<? extends Annotation> bindings) {
        super(type, manager, bindings);
        this.beans = this.getManager().getBeans(this.getType(), bindings.toArray(EMPTY_BINDINGS));
    }

    @Override
    public T get(Annotation ... bindings) {
        Annotation[] annotations = this.mergeInBindings(bindings);
        Bean bean = this.getManager().getBean(ResolvableWeldClass.of(this.getType(), annotations, this.getManager()), annotations);
        Object instance = this.getManager().getReference(bean, this.getType(), this.getManager().createCreationalContext((Contextual)bean));
        return (T)instance;
    }

    @Override
    public T get() {
        return this.get(EMPTY_BINDINGS);
    }

    @Override
    public String toString() {
        return "Obtainable instance for type " + this.getType() + " and binding types " + this.getBindings();
    }

    private Collection<T> getReferences() {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Bean<?> bean : this.beans) {
            Object object;
            Object instance = object = this.getManager().getReference(bean, this.getType(), this.getManager().createCreationalContext((Contextual)bean));
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getReferences().iterator();
    }

    @Override
    public boolean isAmbiguous() {
        return this.beans.size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        return this.beans.size() == 0;
    }

    @Override
    public Instance<T> select(Annotation ... bindings) {
        return this.selectInstance(this.getType(), bindings);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... bindings) {
        return this.selectInstance(subtype, bindings);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return this.selectInstance(subtype.getType(), bindings);
    }

    private <U extends T> Instance<U> selectInstance(Type subtype, Annotation[] bindings) {
        return new InstanceImpl<T>(subtype, this.getManager(), new HashSet<Annotation>(Arrays.asList(this.mergeInBindings(bindings))));
    }

    protected Object readResolve() {
        return new InstanceImpl<T>(this.getType(), this.getManager(), this.getBindings());
    }
}

