/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorImpl<T>
extends ManagedBean<T>
implements Decorator<T> {
    private WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private Set<Annotation> delegateBindings;
    private Type delegateType;
    private Set<Type> delegateTypes;
    private Set<Type> decoratedTypes;

    public static <T> Decorator<T> wrapForResolver(final Decorator<T> decorator) {
        return new ForwardingDecorator<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                return this.delegate().getDelegateQualifiers();
            }

            @Override
            public Set<Type> getTypes() {
                return this.delegate().getTypes();
            }

            @Override
            protected Decorator<T> delegate() {
                return decorator;
            }
        };
    }

    public static <T> DecoratorImpl<T> of(WeldClass<T> clazz, BeanManagerImpl manager) {
        return new DecoratorImpl<T>(clazz, manager);
    }

    protected DecoratorImpl(WeldClass<T> type, BeanManagerImpl manager) {
        super(type, Decorator.class.getSimpleName() + "-" + type.getName(), manager);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initDelegateInjectionPoint();
            this.initDecoratedTypes();
            this.initDelegateBindings();
            this.initDelegateType();
            this.checkDelegateType();
        }
    }

    protected void initDecoratedTypes() {
        this.decoratedTypes = new HashSet<Type>();
        this.decoratedTypes.addAll(this.getAnnotatedItem().getInterfaceOnlyFlattenedTypeHierarchy());
        this.decoratedTypes.remove(Serializable.class);
    }

    protected void initDelegateInjectionPoint() {
        this.delegateInjectionPoint = this.getDelegateInjectionPoints().iterator().next();
    }

    @Override
    protected void checkDelegateInjectionPoints() {
        for (WeldInjectionPoint<?, ?> injectionPoint : this.getDelegateInjectionPoints()) {
            if (!(injectionPoint instanceof MethodInjectionPoint) || injectionPoint.isAnnotationPresent(Inject.class)) continue;
            throw new DefinitionException("Method with @Decorates parameter must be an initializer method " + injectionPoint);
        }
        if (this.getDelegateInjectionPoints().size() == 0) {
            throw new DefinitionException("No delegate injection points defined " + this);
        }
        if (this.getDelegateInjectionPoints().size() > 1) {
            throw new DefinitionException("Too many delegate injection point defined " + this);
        }
    }

    protected void initDelegateBindings() {
        this.delegateBindings = new HashSet<Annotation>();
        this.delegateBindings.addAll(this.delegateInjectionPoint.getQualifiers());
    }

    protected void initDelegateType() {
        this.delegateType = this.delegateInjectionPoint.getBaseType();
        this.delegateTypes = new HashSet<Type>();
        this.delegateTypes.add(this.delegateType);
    }

    protected void checkDelegateType() {
        for (Type decoratedType : this.getDecoratedTypes()) {
            if (decoratedType instanceof Class) {
                if (((Class)decoratedType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
                throw new DefinitionException("The delegate type must extend or implement every decorated type. Decorated type " + decoratedType + "." + this);
            }
            if (!(decoratedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
            if (!this.delegateInjectionPoint.isParameterizedType()) {
                throw new DefinitionException("The decorated type is parameterized, but the delegate type isn't. Delegate type " + this.delegateType + "." + this);
            }
            if (!Arrays.equals(this.delegateInjectionPoint.getActualTypeArguments(), parameterizedType.getActualTypeArguments())) {
                throw new DefinitionException("The delegate type must have exactly the same type parameters as the decorated type. Decorated type " + decoratedType + "." + this);
            }
            Type rawType = ((ParameterizedType)decoratedType).getRawType();
            if (rawType instanceof Class && !((Class)rawType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) {
                throw new DefinitionException("The delegate type must extend or implement every decorated type. Decorated type " + decoratedType + "." + this);
            }
            throw new IllegalStateException("Unable to process " + decoratedType);
        }
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegateBindings;
    }

    @Override
    public Type getDelegateType() {
        return this.delegateType;
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public WeldInjectionPoint<?, ?> getDelegateInjectionPoint() {
        return this.delegateInjectionPoint;
    }

    public Set<Type> getDelegateTypes() {
        return this.delegateTypes;
    }

    @Override
    protected void initDecorators() {
    }

    @Override
    public String getDescription() {
        return super.getDescription("decorator");
    }
}

