/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptionTypeRegistry {
    private static final Log LOG = LogFactory.getLog(InterceptionTypeRegistry.class);
    private static Map<InterceptionType, Class<? extends Annotation>> interceptionAnnotationClasses = new HashMap<InterceptionType, Class<? extends Annotation>>();

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return interceptionAnnotationClasses.keySet();
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return interceptionAnnotationClasses.get((Object)interceptionType);
    }

    static {
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, ReflectionUtils.classForName(interceptionType.getAnnotationClassName()));
            }
            catch (Exception e) {
                LOG.warn("Class '" + interceptionType.getAnnotationClassName() + "' not found, interception based on it is not enabled");
            }
        }
    }
}

