/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Scope;
import java.lang.reflect.Type;
import java.util.Set;

public class ExcludedBeansExtension
implements Extension {
    private final Set<Type> excludedBeanTypes;
    private final Set<Class<?>> excludedBeanClasses;

    ExcludedBeansExtension(Set<Type> excludedBeanTypes, Set<Class<?>> excludedBeanClasses) {
        this.excludedBeanTypes = excludedBeanTypes;
        this.excludedBeanClasses = excludedBeanClasses;
    }

    <T> void excludeBeans(@Observes @WithAnnotations(value={Scope.class, NormalScope.class}) ProcessAnnotatedType<T> pat) {
        if (this.excludedBeanClasses.contains(pat.getAnnotatedType().getJavaClass())) {
            pat.veto();
            return;
        }
        Set typeClosure = pat.getAnnotatedType().getTypeClosure();
        for (Type excludedBeanType : this.excludedBeanTypes) {
            if (!typeClosure.contains(excludedBeanType)) continue;
            pat.veto();
            return;
        }
    }
}

