/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.junit5.auto.AddBeanClasses;
import org.jboss.weld.junit5.auto.AddEnabledDecorators;
import org.jboss.weld.junit5.auto.AddEnabledInterceptors;
import org.jboss.weld.junit5.auto.AddExtensions;
import org.jboss.weld.junit5.auto.AddPackages;
import org.jboss.weld.junit5.auto.EnableAlternativeStereotypes;
import org.jboss.weld.junit5.auto.EnableAlternatives;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;

class ClassScanning {
    ClassScanning() {
    }

    public static void scanForRequiredBeanClass(Class<?> testClass, Weld weld, boolean explicitInjection) {
        ArrayList classesToProcess = new ArrayList();
        classesToProcess.add(testClass);
        HashSet foundClasses = new HashSet();
        while (!classesToProcess.isEmpty()) {
            Class currClass = (Class)classesToProcess.remove(0);
            if (foundClasses.contains(currClass) || currClass.isPrimitive() || currClass.isSynthetic() || currClass.getName().startsWith("java") || currClass.getName().startsWith("sun")) continue;
            foundClasses.add(currClass);
            ClassScanning.findAnnotatedFields(currClass, Object.class, Inject.class).stream().map(Field::getType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, Inject.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().map(Method::getReturnType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            ClassScanning.findFirstAnnotatedConstructor(currClass, Inject.class).map(Stream::of).orElseGet(Stream::empty).flatMap(cons -> ClassScanning.getExecutableParameterTypes(cons, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            ClassScanning.findAnnotatedFields(currClass, Object.class, Produces.class).stream().map(Field::getType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, Produces.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().map(Method::getReturnType).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, Test.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, RepeatedTest.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, BeforeAll.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, BeforeEach.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, AfterEach.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findAnnotatedMethods((Class)currClass, AfterAll.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).stream().flatMap(method -> ClassScanning.getExecutableParameterTypes(method, weld, explicitInjection).stream()).forEach(cls -> ClassScanning.addClassesToProcess(classesToProcess, cls));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddPackages.class).forEach(ann -> Arrays.stream(ann.value()).distinct().forEach(cls -> weld.addPackage(ann.recursively(), cls)));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddBeanClasses.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(arg_0 -> ((Weld)weld).addBeanClass(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddExtensions.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().map(ClassScanning::createExtension).forEach(arg_0 -> ((Weld)weld).addExtension(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddEnabledInterceptors.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(interceptor -> {
                weld.addInterceptor(interceptor);
                weld.addBeanClass(interceptor);
            });
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, AddEnabledDecorators.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(decorator -> {
                weld.addDecorator(decorator);
                weld.addBeanClass(decorator);
            });
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, EnableAlternatives.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(arg_0 -> ((Weld)weld).addAlternative(arg_0));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)currClass, EnableAlternativeStereotypes.class).stream().flatMap(ann -> Arrays.stream(ann.value())).distinct().forEach(arg_0 -> ((Weld)weld).addAlternativeStereotype(arg_0));
        }
        foundClasses.add(testClass);
        for (Class clazz : foundClasses) {
            if (!ClassScanning.hasBeanDefiningAnnotation(clazz)) continue;
            weld.addBeanClass(clazz);
        }
    }

    private static void addClassesToProcess(Collection<Class<?>> classesToProcess, Type type) {
        if (type instanceof Class) {
            classesToProcess.add((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            classesToProcess.add((Class)ptype.getRawType());
            for (Type arg : ptype.getActualTypeArguments()) {
                ClassScanning.addClassesToProcess(classesToProcess, arg);
            }
        }
    }

    private static List<Class<?>> getExecutableParameterTypes(Executable executable, Weld weld, boolean explicitInjection) {
        ArrayList types = new ArrayList();
        if (explicitInjection) {
            Annotation[][] paramAnns = executable.getParameterAnnotations();
            Class<?>[] paramTypes = executable.getParameterTypes();
            for (int c = 0; c < paramAnns.length; ++c) {
                if (!Arrays.stream(paramAnns[c]).anyMatch(ann -> AnnotationSupport.isAnnotated(ann.annotationType(), Qualifier.class) || AnnotationSupport.isAnnotated(ann.annotationType(), NormalScope.class))) continue;
                weld.addBeanClass(paramTypes[c]);
                types.add(paramTypes[c]);
            }
        } else {
            for (Class<?> paramType : executable.getParameterTypes()) {
                weld.addBeanClass(paramType);
                types.add(paramType);
            }
        }
        return types;
    }

    private static Extension createExtension(Class<? extends Extension> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasBeanDefiningAnnotation(Class<?> clazz) {
        return AnnotationUtils.isAnnotated(clazz, ApplicationScoped.class) || AnnotationUtils.isAnnotated(clazz, SessionScoped.class) || AnnotationUtils.isAnnotated(clazz, ConversationScoped.class) || AnnotationUtils.isAnnotated(clazz, RequestScoped.class) || AnnotationUtils.isAnnotated(clazz, Dependent.class) || AnnotationUtils.isAnnotated(clazz, Stereotype.class);
    }

    private static List<Field> findAllFieldsInHierarchy(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        List localFields = ClassScanning.getDeclaredFields(clazz).stream().filter(field -> !field.isSynthetic()).collect(Collectors.toList());
        List superclassFields = ClassScanning.getSuperclassFields(clazz).stream().filter(field -> !ClassScanning.isMethodShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        ArrayList<Field> methods = new ArrayList<Field>();
        methods.addAll(superclassFields);
        methods.addAll(localFields);
        return methods;
    }

    private static List<Field> getSuperclassFields(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && superclass != Object.class ? ClassScanning.findAllFieldsInHierarchy(superclass) : Collections.emptyList();
    }

    private static List<Field> getDeclaredFields(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredFields());
    }

    private static boolean isMethodShadowedByLocalFields(Field field, List<Field> localFields) {
        return localFields.stream().anyMatch(local -> ClassScanning.isFieldShadowedBy(field, local));
    }

    private static boolean isFieldShadowedBy(Field upper, Field lower) {
        return upper.getType().equals(lower.getType());
    }

    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<?> fieldType, Class<? extends Annotation> annotationType) {
        return (List)ClassScanning.getDeclaredFields(clazz).stream().filter(field -> fieldType.isAssignableFrom(field.getType()) && AnnotationSupport.isAnnotated((AnnotatedElement)field, (Class)annotationType)).collect(CollectionUtils.toUnmodifiableList());
    }

    private static List<Constructor<?>> getDeclaredConstructors(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredConstructors());
    }

    public static Optional<Constructor<?>> findFirstAnnotatedConstructor(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Optional<Constructor<?>> found = ClassScanning.getDeclaredConstructors(clazz).stream().filter(cons -> AnnotationSupport.isAnnotated((AnnotatedElement)cons, (Class)annotationType)).findFirst();
        if (found.isPresent() || clazz.getSuperclass() == null) {
            return found;
        }
        return ClassScanning.findFirstAnnotatedConstructor(clazz.getSuperclass(), annotationType);
    }
}

