/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown.Foo;
import org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown.InfoClient;
import org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown.InfoServlet;
import org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown.InitServlet;
import org.jboss.weld.environment.servlet.test.bootstrap.enhanced.shutdown.TestListener;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.jboss.weld.test.util.ActionSequence;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunAsClient
@RunWith(value=Arquillian.class)
public class EnhancedListenerShutdownTest {
    protected static final String TEST = "test";
    protected static final String ASSERT = "assert";
    protected static final Asset TEST_WEB_XML = new StringAsset("<web-app version=\"3.1\"\n   xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xsi:schemaLocation=\"\n      http://xmlns.jcp.org/xml/ns/javaee\n      http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\">" + Deployments.DEFAULT_WEB_XML_BODY + Deployments.toListener(TestListener.class.getName()) + Deployments.toContextParam("WELD_CONTEXT_ID_KEY", "test") + "</web-app>");
    protected static final Asset ASSERT_WEB_XML = new StringAsset("<web-app version=\"3.1\"\n   xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xsi:schemaLocation=\"\n      http://xmlns.jcp.org/xml/ns/javaee\n      http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\">" + Deployments.DEFAULT_WEB_XML_BODY + Deployments.toContextParam("WELD_CONTEXT_ID_KEY", "assert") + "</web-app>");
    @ArquillianResource
    Deployer deployer;

    @Deployment(name="test", managed=false)
    public static WebArchive createTestArchive() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"app-test.war")).addAsWebInfResource((Asset)new BeansXml(), "beans.xml")).setWebXML(TEST_WEB_XML);
        war.addClasses(new Class[]{InitServlet.class, InfoClient.class, Foo.class, TestListener.class});
        return war;
    }

    @Deployment(name="assert", managed=false)
    public static WebArchive createAssertArchive() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"app-assert.war")).addAsWebInfResource((Asset)new BeansXml(), "beans.xml")).setWebXML(Deployments.DEFAULT_WEB_XML);
        war.addClasses(new Class[]{InfoServlet.class, ActionSequence.class});
        return war;
    }

    @Test
    @InSequence(value=1)
    public void deployArchives() {
        this.deployer.deploy(TEST);
        this.deployer.deploy(ASSERT);
    }

    @Test
    @InSequence(value=2)
    public void testEnhancedListenerNotDestroyingWeldIfListenerRegistered(@ArquillianResource @OperateOnDeployment(value="test") URL testContext, @ArquillianResource @OperateOnDeployment(value="assert") URL assertContext) throws IOException {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(testContext + "init?url=" + URLEncoder.encode(assertContext.toExternalForm(), "UTF-8"));
        this.deployer.undeploy(TEST);
        TextPage info = (TextPage)webClient.getPage(assertContext + "info?action=get");
        List data = ActionSequence.buildFromCsvData((String)info.getContent()).getData();
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertEquals((Object)TestListener.class.getSimpleName(), data.get(0));
        Assert.assertEquals((Object)Foo.class.getSimpleName(), data.get(1));
        this.deployer.undeploy(ASSERT);
    }
}

