/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.test.deployment.structure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.weld.environment.servlet.test.deployment.structure.Bar;
import org.jboss.weld.environment.servlet.test.deployment.structure.Baz;
import org.jboss.weld.environment.servlet.test.deployment.structure.ContainerLifecycleObserver;
import org.jboss.weld.environment.servlet.test.deployment.structure.Foo;
import org.jboss.weld.environment.servlet.test.deployment.structure.Garply;
import org.jboss.weld.environment.servlet.test.util.Deployments;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentOrderingTestBase {
    public static final Asset EXTENSION = new ByteArrayAsset(ContainerLifecycleObserver.class.getName().getBytes());

    public static WebArchive deployment() {
        WebArchive war = Deployments.baseDeployment();
        war.delete(ArchivePaths.create((String)"WEB-INF/beans.xml"));
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)war.addPackage(DeploymentOrderingTestBase.class.getPackage())).addAsWebInfResource((Asset)new BeansXml().alternatives(new Class[]{Bar.class}), "beans.xml")).addAsWebInfResource((Asset)new BeansXml().alternatives(new Class[]{Garply.class}), "classes/META-INF/beans.xml")).addAsWebInfResource(EXTENSION, "classes/META-INF/services/" + Extension.class.getName());
    }

    @Test
    public void testBeansXmlMerged(BeanManager beanManager) {
        Assert.assertEquals(Bar.class, (Object)beanManager.resolve(beanManager.getBeans(Foo.class, new Annotation[0])).getBeanClass());
        Assert.assertEquals(Garply.class, (Object)beanManager.resolve(beanManager.getBeans(Baz.class, new Annotation[0])).getBeanClass());
    }

    @Test
    public void testProcessAnnotatedTypeCalledOnceOnlyPerType(ContainerLifecycleObserver containerLifecycleObserver) {
        Assert.assertEquals((String)containerLifecycleObserver.getProcessedAnnotatedTypes().toString(), (long)4L, (long)containerLifecycleObserver.getProcessedAnnotatedTypes().size());
        ArrayList<Class> classes = new ArrayList<Class>();
        for (AnnotatedType<?> annotatedType : containerLifecycleObserver.getProcessedAnnotatedTypes()) {
            classes.add(annotatedType.getJavaClass());
        }
        Assert.assertTrue((boolean)classes.contains(Foo.class));
        Assert.assertTrue((boolean)classes.contains(Bar.class));
        Assert.assertTrue((boolean)classes.contains(Baz.class));
        Assert.assertTrue((boolean)classes.contains(Garply.class));
    }
}

