/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.validation.StringFormatValidator;

@SupportedOptions(value={"generatedTranslationFilesPath", "org.jboss.logging.tools.level", "org.jboss.logging.tools.generated.skip.index"})
final class TranslationFileGenerator
extends AbstractGenerator {
    private static final Map<String, Integer> levels = new HashMap<String, Integer>();
    private static final Pattern PATTERN = Pattern.compile("((@[a-zA-Z_0-9]+)\\s+([a-zA-Z_][a-zA-Z_0-9]*)\\s+([a-zA-Z_][a-zA-Z_0-9].*)\\s*)");
    private static final String EMPTY_STRING = "";
    private static final String JAVA_DOC_PARAM = "@param";
    private static final String DEFAULT_FILE_EXTENSION = ".i18n.properties";
    private static final String DEFAULT_FILE_COMMENT = "# This file is for reference only, changes have no effect on the generated interface implementations.";
    static final String GENERATED_FILES_PATH_OPTION = "generatedTranslationFilesPath";
    static final String GENERATED_FILE_EXTENSION = ".i18n_locale_COUNTRY_VARIANT.properties";
    static final String LEVEL_OPTION = "org.jboss.logging.tools.level";
    static final String SKIP_INDEX = "org.jboss.logging.tools.generated.skip.index";
    private final String generatedFilesPath;
    private final LevelComparator comparator;
    private final boolean skipIndex;

    TranslationFileGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.generatedFilesPath = options.get(GENERATED_FILES_PATH_OPTION);
        String highLevel = options.get(LEVEL_OPTION);
        if (highLevel == null) {
            highLevel = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(TranslationFileGenerator.LEVEL_OPTION);
                }
            });
        }
        if (highLevel != null) {
            if (!levels.containsKey(highLevel)) {
                this.logger().error("Invalid property '%s' defined. The value %s is invalid.", LEVEL_OPTION, highLevel);
            }
            this.comparator = new LevelComparator(highLevel);
        } else {
            this.comparator = null;
        }
        String value = options.get(SKIP_INDEX);
        this.skipIndex = options.containsKey(SKIP_INDEX) && (value == null || value.isEmpty() || Boolean.parseBoolean(value));
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, MessageInterface messageInterface) {
        if (this.generatedFilesPath != null && element.getKind().isInterface()) {
            String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
            String relativePath = packageName.replace('.', File.separatorChar);
            String fileName = TranslationFileGenerator.getPrimaryClassNamePrefix(element) + GENERATED_FILE_EXTENSION;
            this.generateSkeletalTranslationFile(relativePath, fileName, messageInterface);
        }
        this.generateDefaultTranslationFile(messageInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generateSkeletalTranslationFile(String relativePath, String fileName, MessageInterface messageInterface) {
        block15: {
            if (messageInterface == null) {
                throw new IllegalArgumentException("The translations parameter cannot be null");
            }
            File pathFile = new File(this.generatedFilesPath, relativePath);
            pathFile.mkdirs();
            File file = new File(pathFile, fileName);
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(file));
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!this.isMethodWritable(messageMethod) || !processed.add(messageMethod.translationKey())) continue;
                this.writeSkeletonMessageMethod(writer, messageMethod);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block15;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot close generated skeletal translation file %s", fileName);
            }
            break block15;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated skeletal translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot close generated skeletal translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot close generated skeletal translation file %s", fileName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generateDefaultTranslationFile(MessageInterface messageInterface) {
        block16: {
            String fileName = messageInterface.simpleName() + DEFAULT_FILE_EXTENSION;
            BufferedWriter writer = null;
            if (this.generatedFilesPath == null) {
                FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, messageInterface.packageName(), fileName, new Element[0]);
                writer = new BufferedWriter(fileObject.openWriter());
            } else {
                String relativePath = messageInterface.packageName().replace('.', File.separatorChar);
                File path = new File(this.generatedFilesPath, relativePath);
                path.mkdirs();
                File file = new File(path, fileName);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            }
            TranslationFileGenerator.writeSeparatorLine(writer);
            writer.write("#");
            writer.newLine();
            writer.write(DEFAULT_FILE_COMMENT);
            writer.newLine();
            writer.write("#");
            writer.newLine();
            TranslationFileGenerator.writeSeparatorLine(writer);
            writer.newLine();
            HashSet<String> processed = new HashSet<String>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                if (!this.isMethodWritable(messageMethod) || !processed.add(messageMethod.translationKey())) continue;
                this.writeSkeletonMessageMethod(writer, messageMethod);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block16;
            }
            catch (IOException e) {
                this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
            }
            break block16;
            catch (IOException e) {
                try {
                    this.logger().error((Throwable)e, "Cannot write generated default translation file %s", fileName);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger().error((Throwable)e2, "Cannot write generated default translation file %s", fileName);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    this.logger().error((Throwable)e3, "Cannot write generated default translation file %s", fileName);
                }
            }
        }
    }

    private void writeSkeletonMessageMethod(BufferedWriter writer, MessageMethod messageMethod) throws IOException {
        MessageMethod.Message msg = messageMethod.message();
        writer.write(String.format("# Id: %s", msg.hasId() ? Integer.valueOf(msg.id()) : "none"));
        writer.newLine();
        if (messageMethod instanceof LoggerMessageMethod) {
            writer.write(String.format("# Level: %s", ((LoggerMessageMethod)messageMethod).logLevel()));
            writer.newLine();
        }
        writer.write(String.format("# Message: %s", msg.value()));
        writer.newLine();
        Map<String, String> parameterComments = this.parseParameterComments(messageMethod);
        int i = 0;
        for (Parameter parameter : messageMethod.parameters()) {
            String comment;
            String name = parameter.name();
            String string = comment = parameterComments.containsKey(name) ? parameterComments.get(name) : EMPTY_STRING;
            if (parameter.isAnnotatedWith(Transform.class)) {
                List<Transform.TransformType> transformTypes = Arrays.asList(parameter.getAnnotation(Transform.class).value());
                if (transformTypes.contains((Object)Transform.TransformType.GET_CLASS)) {
                    if (transformTypes.size() == 1) {
                        writer.write(String.format("# @param class of %s - %s", name, comment));
                    } else if (transformTypes.contains((Object)Transform.TransformType.HASH_CODE)) {
                        writer.write(String.format("# @param hashCode of class of %s - %s", name, comment));
                    } else if (transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE)) {
                        writer.write(String.format("# @param identityHashCode of class of %s - %s", name, comment));
                    }
                } else if (transformTypes.contains((Object)Transform.TransformType.HASH_CODE)) {
                    writer.write(String.format("# @param hashCode of %s - %s", name, comment));
                } else if (transformTypes.contains((Object)Transform.TransformType.IDENTITY_HASH_CODE)) {
                    writer.write(String.format("# @param identityHashCode of %s - %s", name, comment));
                } else if (transformTypes.contains((Object)Transform.TransformType.SIZE)) {
                    if (parameter.isArray() || parameter.isVarArgs() || parameter.isSubtypeOf(String.class)) {
                        writer.write(String.format("# @param length of %s - %s", name, comment));
                    } else {
                        writer.write(String.format("# @param size of %s - %s", name, comment));
                    }
                }
                writer.newLine();
                continue;
            }
            if (!parameter.isFormatParameter()) continue;
            writer.write(String.format("# @param %d: %s - %s", ++i, name, comment));
            writer.newLine();
        }
        writer.write(String.format("%s=", messageMethod.translationKey()));
        if (!this.skipIndex && messageMethod.message().format() == Message.Format.PRINTF) {
            writer.write(this.addIndexesToFormat(messageMethod));
        } else {
            writer.write(messageMethod.message().value());
        }
        writer.newLine();
    }

    private Map<String, String> parseParameterComments(MessageMethod messageMethod) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String comment = messageMethod.getComment();
        if (comment != null) {
            Matcher matcher = PATTERN.matcher(comment);
            while (matcher.find()) {
                String annotation;
                if (matcher.groupCount() <= 3 || (annotation = matcher.group(2)) == null || !annotation.trim().equals(JAVA_DOC_PARAM)) continue;
                result.put(matcher.group(3), matcher.group(4));
            }
        }
        return result;
    }

    private boolean isMethodWritable(MessageMethod method) {
        if (method instanceof LoggerMessageMethod && this.comparator != null) {
            return this.comparator.compareTo(((LoggerMessageMethod)method).logLevel()) >= 0;
        }
        return true;
    }

    private static void writeSeparatorLine(BufferedWriter writer) throws IOException {
        int len = DEFAULT_FILE_COMMENT.length();
        for (int i = 0; i < len; ++i) {
            writer.append('#');
        }
        writer.newLine();
    }

    private static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    private String addIndexesToFormat(MessageMethod method) {
        String result;
        StringFormatValidator validator;
        String format = method.message().value();
        int pos = 0;
        int i = 0;
        Matcher matcher = StringFormatValidator.PATTERN.matcher(format);
        StringBuilder newFormat = new StringBuilder();
        while (i < format.length()) {
            if (matcher.find(i)) {
                if (matcher.start() != i) {
                    newFormat.append(format, i, matcher.start());
                }
                if (matcher.groupCount() != 6) {
                    this.logger().warn(method, "Invalid format using \"%s\" for the skeleton value.", format);
                    return format;
                }
                newFormat.append('%');
                String index = matcher.group(1);
                String flags = matcher.group(2);
                String width = matcher.group(3);
                String precision = matcher.group(4);
                String t = matcher.group(5);
                char conversion = matcher.group(6).charAt(0);
                if (index == null) {
                    if (flags != null && !flags.contains("<") && conversion != 'n' && conversion != '%') {
                        newFormat.append(++pos).append('$');
                    }
                } else {
                    newFormat.append(index);
                }
                if (flags != null) {
                    newFormat.append(flags);
                }
                if (width != null) {
                    newFormat.append(width);
                }
                if (precision != null) {
                    newFormat.append(precision);
                }
                if (t != null) {
                    newFormat.append(t);
                }
                newFormat.append(conversion);
                i = matcher.end();
                continue;
            }
            newFormat.append(format, i, format.length());
            break;
        }
        if (!(validator = StringFormatValidator.of(result = newFormat.toString())).isValid()) {
            this.logger().warn(method, "Could not properly use indexes in the format %s.", format);
            return format;
        }
        return result;
    }

    static {
        levels.put("ALL", Integer.MIN_VALUE);
        levels.put("CONFIG", 700);
        levels.put("DEBUG", 500);
        levels.put("ERROR", 1000);
        levels.put("FATAL", 1100);
        levels.put("FINE", 500);
        levels.put("FINER", 400);
        levels.put("FINEST", 300);
        levels.put("INFO", 800);
        levels.put("OFF", Integer.MAX_VALUE);
        levels.put("SEVERE", 1000);
        levels.put("TRACE", 400);
        levels.put("WARN", 900);
        levels.put("WARNING", 900);
    }

    private static final class LevelComparator
    implements Comparable<String> {
        private final Integer levelIntValue;

        private LevelComparator(String level) {
            this.levelIntValue = levels.get(level);
            if (this.levelIntValue == null) {
                throw new IllegalArgumentException(String.format("Level %s is invalid.", level));
            }
        }

        @Override
        public int compareTo(String o) {
            Integer level;
            String cmpLevel = o;
            int lastDot = o.lastIndexOf(".");
            if (lastDot > -1) {
                cmpLevel = o.substring(lastDot + 1);
            }
            if ((level = levels.get(cmpLevel)) == null) {
                throw new IllegalArgumentException(String.format("Level %s is invalid.", cmpLevel));
            }
            return level.compareTo(this.levelIntValue);
        }
    }
}

