package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class InvokerLogger_$logger extends DelegatingBasicLogger implements InvokerLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InvokerLogger_$logger.class.getName();
    public InvokerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidArgumentPosition$str() {
        return "WELD-002000: Cannot apply {0} to method argument with position {1}; total number of method parameters is {2}";
    }
    @Override
    public final IllegalArgumentException invalidArgumentPosition(final String kindOfTransformer, final int position, final int argLookupLength) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidArgumentPosition$str(), kindOfTransformer, position, argLookupLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String settingTransformerRepeatedly$str() {
        return "WELD-002001: {0} transformer is already set! InvokerBuilder transformers cannot be set repeatedly.";
    }
    @Override
    public final IllegalArgumentException settingTransformerRepeatedly(final String kindOfTransformer) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(settingTransformerRepeatedly$str(), kindOfTransformer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTransformerMethod$str() {
        return "WELD-002002: Invalid {0} transformer method: {1}";
    }
    @Override
    public final IllegalStateException invalidTransformerMethod(final String kindOfTransformer, final Object transformerMetadata) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidTransformerMethod$str(), kindOfTransformer, transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMatchingTransformerMethod$str() {
        return "WELD-002003: No matching transformer method found for {0}. There has to be exactly one matching method.";
    }
    @Override
    public final IllegalStateException noMatchingTransformerMethod(final Object transformerMetadata) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(noMatchingTransformerMethod$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleMatchingTransformerMethod$str() {
        return "WELD-002004: Multiple matching transformer methods found for {0}. There has to be exactly one matching method; instead, following methods were found: {1}";
    }
    @Override
    public final DeploymentException multipleMatchingTransformerMethod(final Object transformerMetadata, final Object listOfMatches) {
        final DeploymentException result = new DeploymentException(_formatMessage(multipleMatchingTransformerMethod$str(), transformerMetadata, listOfMatches));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateMethodHandle$str() {
        return "WELD-002005: Unable to create method handle for method: {0}";
    }
    @Override
    public final RuntimeException cannotCreateMethodHandle(final Object method, final Throwable cause) {
        final RuntimeException result = new RuntimeException(_formatMessage(cannotCreateMethodHandle$str(), method), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonPublicTransformer$str() {
        return "WELD-002006: All invocation transformers need to be public - {0}";
    }
    @Override
    public final DeploymentException nonPublicTransformer(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(nonPublicTransformer$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inputTransformerNotAssignable$str() {
        return "WELD-002007: Input transformer {0} has a return value that is not assignable to expected class: {1}";
    }
    @Override
    public final DeploymentException inputTransformerNotAssignable(final Object transformerMetadata, final Object clazz) {
        final DeploymentException result = new DeploymentException(_formatMessage(inputTransformerNotAssignable$str(), transformerMetadata, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonStaticInputTransformerHasParams$str() {
        return "WELD-002008: Non-static input transformers are expected to have zero input parameters! Transformer: {0}";
    }
    @Override
    public final DeploymentException nonStaticInputTransformerHasParams(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(nonStaticInputTransformerHasParams$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String staticInputTransformerParams$str() {
        return "WELD-002009: Static input transformers can only have one or two parameters! Transformer: {0}";
    }
    @Override
    public final DeploymentException staticInputTransformerParams(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(staticInputTransformerParams$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String staticInputTransformerIncorrectParams$str() {
        return "WELD-002010: Static input transformers with two parameters can only have Consumer<Runnable> as their second parameter! Transformer: {0}";
    }
    @Override
    public final DeploymentException staticInputTransformerIncorrectParams(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(staticInputTransformerIncorrectParams$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonStaticOutputTransformerHasParams$str() {
        return "WELD-002011: Non-static output transformers are expected to have zero input parameters! Transformer: {0}";
    }
    @Override
    public final DeploymentException nonStaticOutputTransformerHasParams(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(nonStaticOutputTransformerHasParams$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String staticOutputTransformerParams$str() {
        return "WELD-002012: Static output transformers are expected to have one input parameter! Transformer: {0}";
    }
    @Override
    public final DeploymentException staticOutputTransformerParams(final Object transformerMetadata) {
        final DeploymentException result = new DeploymentException(_formatMessage(staticOutputTransformerParams$str(), transformerMetadata));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outputTransformerNotAssignable$str() {
        return "WELD-002013: Output transformer {0} parameter is not assignable to the expected class: {1}";
    }
    @Override
    public final DeploymentException outputTransformerNotAssignable(final Object transformerMetadata, final Object clazz) {
        final DeploymentException result = new DeploymentException(_formatMessage(outputTransformerNotAssignable$str(), transformerMetadata, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrapperUnexpectedParams$str() {
        return "WELD-002014: Invocation wrapper has unexpected parameters: {0} \nExpected param types are: {1}, Object[], Invoker.class";
    }
    @Override
    public final DeploymentException wrapperUnexpectedParams(final Object transformerMetadata, final Object clazz) {
        final DeploymentException result = new DeploymentException(_formatMessage(wrapperUnexpectedParams$str(), transformerMetadata, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
