/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import javax.servlet.ServletContext;
import org.jboss.weld.environment.jetty.AbstractJettyContainer;
import org.jboss.weld.environment.jetty.WeldDecorator;
import org.jboss.weld.environment.servlet.Container;
import org.jboss.weld.environment.servlet.ContainerContext;
import org.jboss.weld.environment.servlet.logging.JettyLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public class JettyContainer
extends AbstractJettyContainer {
    public static final Container INSTANCE = new JettyContainer();
    public static final String JETTY_DECORATING_ATTRIBUTE = "org.eclipse.jetty.webapp.DecoratingListener";
    public static final String JETTY_CDI_ATTRIBUTE = "org.eclipse.jetty.cdi";
    public static final String JETTY_CDI_VALUE = "CdiDecorator";

    @Override
    protected String classToCheck() {
        throw new UnsupportedOperationException("touch method reimplemented in JettyContainer");
    }

    @Override
    public boolean touch(ResourceLoader resourceLoader, ContainerContext context) throws Exception {
        ServletContext sc = context.getServletContext();
        return sc.getAttribute(JETTY_DECORATING_ATTRIBUTE) instanceof String || JETTY_CDI_VALUE.equals(sc.getAttribute(JETTY_CDI_ATTRIBUTE));
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            ServletContext servletContext = context.getServletContext();
            if (JETTY_CDI_VALUE.equals(servletContext.getAttribute(JETTY_CDI_ATTRIBUTE))) {
                JettyLogger.LOG.jettyCdiSpiIsSupported();
            } else {
                super.initialize(context);
                WeldDecorator.process(servletContext);
            }
        }
        catch (Exception e) {
            JettyLogger.LOG.unableToCreateJettyWeldInjector(e);
        }
    }
}

