/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import javax.servlet.ServletContext;
import org.jboss.weld.environment.jetty.AbstractJettyContainer;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.jetty.WeldDecorator;
import org.jboss.weld.environment.servlet.Container;
import org.jboss.weld.environment.servlet.ContainerContext;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.logging.JettyLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public class JettyContainer
extends AbstractJettyContainer {
    public static final Container INSTANCE = new JettyContainer();
    private static final String JETTY_SERVERNAME = "jetty";
    private static final String JETTY_REQUIRED_CLASS_NAME = "org.eclipse.jetty.servlet.ServletHandler";
    private static final int MAJOR_VERSION = 7;
    private static final int MINOR_VERSION = 2;

    @Override
    protected String classToCheck() {
        return JETTY_REQUIRED_CLASS_NAME;
    }

    @Override
    public boolean touch(ResourceLoader resourceLoader, ContainerContext context) throws Exception {
        ServletContext sc = context.getServletContext();
        String si = sc.getServerInfo();
        JettyLogger.LOG.debugv("Parsing server info: {0}", (Object)si);
        if (!si.contains(JETTY_SERVERNAME)) {
            return false;
        }
        int p = si.indexOf("/");
        if (p < 0) {
            return false;
        }
        String version = si.substring(p + 1);
        String[] split = version.split("\\.");
        int major = this.parseVersion(split[0]);
        int minor = this.parseVersion(split[1]);
        return major > 7 || major == 7 & minor >= 2;
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            context.getServletContext().setAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector", (Object)new JettyWeldInjector(context.getManager()));
            WeldDecorator.process(context.getServletContext());
            if (Boolean.TRUE.equals(context.getServletContext().getAttribute(EnhancedListener.ENHANCED_LISTENER_USED_ATTRIBUTE_NAME))) {
                JettyLogger.LOG.jettyDetectedListenersInjectionIsSupported();
            } else {
                JettyLogger.LOG.jettyDetectedListenersInjectionIsNotSupported();
            }
        }
        catch (Exception e) {
            JettyLogger.LOG.unableToCreateJettyWeldInjector(e);
        }
    }

    private int parseVersion(String version) {
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            JettyLogger.LOG.debugv("Unable to parse version string: {0}", (Object)version);
            return -1;
        }
    }
}

