/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.inject.spi.Annotated;

abstract class AnnotatedConfigurator<T, A extends Annotated, C extends AnnotatedConfigurator<T, A, C>> {
    private final A annotated;
    private final Set<Annotation> annotations;

    AnnotatedConfigurator(A annotated) {
        this.annotated = annotated;
        this.annotations = new HashSet<Annotation>(annotated.getAnnotations());
    }

    public A getAnnotated() {
        return this.annotated;
    }

    public C add(Annotation annotation) {
        this.annotations.add(annotation);
        return this.self();
    }

    public C remove(Predicate<Annotation> predicate) {
        Iterator<Annotation> iterator = this.annotations.iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
        }
        return this.self();
    }

    public C removeAll() {
        this.annotations.clear();
        return this.self();
    }

    protected abstract C self();

    Set<Annotation> getAnnotations() {
        return this.annotations;
    }
}

