/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Named;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.TypeEqualitySpecializationUtils;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractBean<T, S>
extends RIBean<T> {
    protected Class<T> type;
    private boolean preInitialized;
    private boolean proxyRequired;
    private Producer<T> producer;
    private boolean ignoreFinalMethods;

    public AbstractBean(BeanAttributes<T> attributes, BeanIdentifier identifier, BeanManagerImpl beanManager) {
        super(attributes, identifier, beanManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInitialize() {
        AbstractBean abstractBean = this;
        synchronized (abstractBean) {
            if (this.isSpecializing() && !this.preInitialized) {
                this.preInitialized = true;
                this.preSpecialize();
                this.specialize();
                this.checkSpecialization();
                this.postSpecialize();
            }
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.preInitialize();
        BeanLogger.LOG.creatingBean(this.getType());
        this.proxyRequired = this.getScope() != null ? this.isNormalScoped() : false;
        BeanLogger.LOG.qualifiersUsed(this.getQualifiers(), this);
        BeanLogger.LOG.usingName(this.getName(), this);
        BeanLogger.LOG.usingScope(this.getScope(), this);
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.checkType();
    }

    protected abstract void checkType();

    public void checkSpecialization() {
        if (this.isSpecializing()) {
            boolean isNameDefined = this.getAnnotated().isAnnotationPresent(Named.class);
            String previousSpecializedBeanName = null;
            for (AbstractBean<?, ?> specializedBean : this.getSpecializedBeans()) {
                String name = specializedBean.getName();
                if (previousSpecializedBeanName != null && name != null && !previousSpecializedBeanName.equals(specializedBean.getName())) {
                    throw BeanLogger.LOG.beansWithDifferentBeanNamesCannotBeSpecialized(previousSpecializedBeanName, specializedBean.getName(), this);
                }
                previousSpecializedBeanName = name;
                if (isNameDefined && name != null) {
                    throw BeanLogger.LOG.nameNotAllowedOnSpecialization(this.getAnnotated(), specializedBean.getAnnotated());
                }
                boolean rawInsteadOfGeneric = this instanceof AbstractClassBean && specializedBean.getBeanClass().getTypeParameters().length > 0 && !(((AbstractClassBean)this).getBeanClass().getGenericSuperclass() instanceof ParameterizedType);
                for (Type specializedType : specializedBean.getTypes()) {
                    if (rawInsteadOfGeneric && specializedType instanceof ParameterizedType) {
                        throw BeanLogger.LOG.specializingBeanMissingSpecializedType(this, specializedType, specializedBean);
                    }
                    boolean contains = this.getTypes().contains(specializedType);
                    if (!contains) {
                        for (Type specializingType : this.getTypes()) {
                            if (!TypeEqualitySpecializationUtils.areTheSame(specializingType, specializedType)) continue;
                            contains = true;
                            break;
                        }
                    }
                    if (contains) continue;
                    throw BeanLogger.LOG.specializingBeanMissingSpecializedType(this, specializedType, specializedBean);
                }
            }
        }
    }

    protected void postSpecialize() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation qualifier : this.attributes().getQualifiers()) {
            if (qualifier.equals(DefaultLiteral.INSTANCE) && !this.getAnnotated().isAnnotationPresent(Default.class)) continue;
            qualifiers.add(qualifier);
        }
        String name = this.attributes().getName();
        for (AbstractBean<?, ?> specializedBean : this.getSpecializedBeans()) {
            qualifiers.addAll(specializedBean.getQualifiers());
            if (specializedBean.getName() == null) continue;
            name = specializedBean.getName();
        }
        this.setAttributes(new ImmutableBeanAttributes(qualifiers, name, this.attributes()));
    }

    protected void preSpecialize() {
    }

    protected void specialize() {
    }

    public abstract Annotated getAnnotated();

    public abstract EnhancedAnnotated<T, S> getEnhancedAnnotated();

    protected Set<? extends AbstractBean<?, ?>> getSpecializedBeans() {
        return this.getBeanManager().getServices().get(SpecializationAndEnablementRegistry.class).resolveSpecializedBeans(this);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    public boolean isSpecializing() {
        return this.getAnnotated().isAnnotationPresent(Specializes.class);
    }

    @Override
    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }

    public boolean isIgnoreFinalMethods() {
        return this.ignoreFinalMethods;
    }

    public void setIgnoreFinalMethods() {
        this.ignoreFinalMethods = true;
    }
}

