/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategyFactory;
import org.jboss.weld.environment.gwtdev.GwtDevHostedModeContainer;
import org.jboss.weld.environment.jetty.JettyContainer;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.servlet.deployment.ServletContextBeanArchiveHandler;
import org.jboss.weld.environment.servlet.deployment.WebAppBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.ServiceLoader;
import org.jboss.weld.environment.tomcat.TomcatContainer;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.servlet.api.ServletListener;

public class WeldServletLifecycle {
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + "." + BeanManager.class.getName();
    private static final String CONTEXT_ID_KEY = "WELD_CONTEXT_ID_KEY";
    static final String INSTANCE_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + ".lifecycleInstance";
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private static final String WELD_LISTENER_CLASS_NAME = "org.jboss.weld.servlet.WeldInitialListener";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private static final String CONTEXT_PARAM_ARCHIVE_ISOLATION = WeldServletLifecycle.class.getPackage().getName() + ".archive.isolation";
    private final transient CDI11Bootstrap bootstrap;
    private final transient ServletListener weldListener;
    private Container container;
    private boolean isBootstrapNeeded = true;

    WeldServletLifecycle() {
        try {
            this.bootstrap = (CDI11Bootstrap)Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw WeldServletLogger.LOG.errorLoadingWeldBootstrap(e);
        }
        try {
            this.weldListener = (ServletListener)Reflections.newInstance(WELD_LISTENER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw WeldServletLogger.LOG.errorLoadingWeldListener(e);
        }
    }

    boolean initialize(ServletContext context) {
        StringBuilder dump;
        ContainerContext containerContext;
        Container container;
        WeldManager manager = (WeldManager)context.getAttribute(BEAN_MANAGER_ATTRIBUTE_NAME);
        if (manager != null) {
            this.isBootstrapNeeded = false;
        }
        if (this.isBootstrapNeeded) {
            CDI11Deployment deployment = this.createDeployment(context, this.bootstrap);
            if (deployment.getBeanDeploymentArchives().isEmpty()) {
                CommonLogger.LOG.initSkippedNoBeanArchiveFound();
                return false;
            }
            ServletResourceInjectionServices resourceInjectionServices = new ServletResourceInjectionServices(){};
            try {
                for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
                    archive.getServices().add(ResourceInjectionServices.class, resourceInjectionServices);
                }
            }
            catch (NoClassDefFoundError e) {
                WeldServletLogger.LOG.resourceInjectionNotAvailable();
            }
            String id = context.getInitParameter(CONTEXT_ID_KEY);
            if (id != null) {
                this.bootstrap.startContainer(id, Environments.SERVLET, deployment);
            } else {
                this.bootstrap.startContainer(Environments.SERVLET, deployment);
            }
            this.bootstrap.startInitialization();
            manager = this.bootstrap.getManager(deployment.getBeanDeploymentArchives().iterator().next());
            context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        }
        if ((container = this.findContainer(containerContext = new ContainerContext(context, manager), dump = new StringBuilder())) == null) {
            WeldServletLogger.LOG.noSupportedServletContainerDetected();
            WeldServletLogger.LOG.debugv("Exception dump from Container lookup: {0}", (Object)dump);
        } else {
            container.initialize(containerContext);
            this.container = container;
        }
        if (JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            try {
                jspApplicationContext.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            }
            catch (IllegalArgumentException e) {
                throw WeldServletLogger.LOG.errorLoadingWeldELContextListener(e);
            }
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        if (this.isBootstrapNeeded) {
            this.bootstrap.deployBeans().validateBeans().endInitialization();
        }
        return true;
    }

    void destroy(ServletContext context) {
        if (this.isBootstrapNeeded) {
            this.bootstrap.shutdown();
        }
        if (this.container != null) {
            this.container.destroy(new ContainerContext(context, null));
        }
    }

    ServletListener getWeldListener() {
        return this.weldListener;
    }

    protected CDI11Deployment createDeployment(ServletContext context, CDI11Bootstrap bootstrap) {
        WeldResourceLoader resourceLoader = new WeldResourceLoader();
        Iterable<Metadata<Extension>> extensions = bootstrap.loadExtensions(WeldResourceLoader.getClassLoader());
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(extensions);
        DiscoveryStrategy strategy = DiscoveryStrategyFactory.create(resourceLoader, bootstrap, typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations());
        strategy.registerHandler(new ServletContextBeanArchiveHandler(context));
        strategy.setScanner(new WebAppBeanArchiveScanner(resourceLoader, bootstrap, context));
        Set<WeldBeanDeploymentArchive> beanDeploymentArchives = strategy.performDiscovery();
        String isolation = context.getInitParameter(CONTEXT_PARAM_ARCHIVE_ISOLATION);
        if (isolation != null && Boolean.valueOf(isolation).equals(Boolean.FALSE)) {
            CommonLogger.LOG.archiveIsolationDisabled();
            beanDeploymentArchives = Collections.singleton(WeldBeanDeploymentArchive.merge(bootstrap, beanDeploymentArchives));
        } else {
            CommonLogger.LOG.archiveIsolationEnabled();
        }
        WeldDeployment deployment = new WeldDeployment(resourceLoader, bootstrap, beanDeploymentArchives, extensions);
        if (strategy.getClassFileServices() != null) {
            deployment.getServices().add(ClassFileServices.class, strategy.getClassFileServices());
        }
        return deployment;
    }

    protected Container findContainer(ContainerContext ctx, StringBuilder dump) {
        Iterable<Container> extContainers;
        Container container = null;
        String containerClass = ctx.getServletContext().getInitParameter(Container.CONTEXT_PARAM_CONTAINER_CLASS);
        if (containerClass != null) {
            try {
                container = (Container)Reflections.newInstance(containerClass);
                WeldServletLogger.LOG.containerDetectionSkipped(containerClass);
            }
            catch (IllegalArgumentException e) {
                WeldServletLogger.LOG.unableToInstantiateCustomContainerClass(containerClass);
            }
        }
        if (container == null && (container = this.checkContainers(ctx, dump, extContainers = ServiceLoader.load(Container.class, this.getClass().getClassLoader()))) == null) {
            container = this.checkContainers(ctx, dump, Arrays.asList(TomcatContainer.INSTANCE, JettyContainer.INSTANCE, GwtDevHostedModeContainer.INSTANCE));
        }
        return container;
    }

    protected Container checkContainers(ContainerContext cc, StringBuilder dump, Iterable<Container> containers) {
        for (Container c : containers) {
            try {
                if (!c.touch(cc)) continue;
                return c;
            }
            catch (Throwable t) {
                dump.append(c).append("->").append(t.getMessage()).append("\n");
            }
        }
        return null;
    }
}

