/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.util.cache.ComputingCache;

public class JandexClassFileInfo
implements ClassFileInfo {
    private static final DotName DOT_NAME_INJECT = DotName.createSimple((String)Inject.class.getName());
    private static final DotName DOT_NAME_VETOED = DotName.createSimple((String)Vetoed.class.getName());
    private static final DotName OBJECT_NAME = DotName.createSimple((String)Object.class.getName());
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final String PACKAGE_INFO_NAME = "package-info";
    private final ClassInfo classInfo;
    private final IndexView index;
    private final boolean isVetoed;
    private final boolean hasCdiConstructor;
    private final ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader classLoader;
    private static final Logger log = Logger.getLogger(JandexClassFileInfo.class);

    public JandexClassFileInfo(String className, IndexView index, ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache, ClassLoader classLoader) {
        this.index = index;
        this.annotationClassAnnotationsCache = annotationClassAnnotationsCache;
        this.classInfo = index.getClassByName(DotName.createSimple((String)className));
        if (this.classInfo == null) {
            throw CommonLogger.LOG.indexForNameNotFound(className);
        }
        this.isVetoed = this.isVetoedTypeOrPackage();
        this.hasCdiConstructor = this.classInfo.hasNoArgsConstructor() || this.hasInjectConstructor();
        this.classLoader = classLoader;
    }

    @Override
    public String getClassName() {
        return this.classInfo.name().toString();
    }

    @Override
    public boolean isAnnotationDeclared(Class<? extends Annotation> annotation) {
        return this.isAnnotationDeclared(this.classInfo, annotation);
    }

    @Override
    public boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return this.containsAnnotation(this.classInfo, DotName.createSimple((String)annotation.getName()), annotation);
    }

    @Override
    public int getModifiers() {
        return this.classInfo.flags();
    }

    @Override
    public boolean hasCdiConstructor() {
        return this.hasCdiConstructor;
    }

    @Override
    public boolean isAssignableFrom(Class<?> fromClass) {
        return this.isAssignableFrom(this.getClassName(), fromClass);
    }

    @Override
    public boolean isAssignableTo(Class<?> toClass) {
        return this.isAssignableTo(this.classInfo.name(), toClass);
    }

    @Override
    public boolean isVetoed() {
        return this.isVetoed;
    }

    @Override
    public boolean isTopLevelClass() {
        return !this.classInfo.name().local().contains("$");
    }

    @Override
    public String getSuperclassName() {
        return this.classInfo.superName().toString();
    }

    private boolean isVetoedTypeOrPackage() {
        if (this.isAnnotationDeclared(this.classInfo, DOT_NAME_VETOED)) {
            return true;
        }
        DotName packageInfoName = DotName.createComponentized((DotName)this.getPackageName(this.classInfo.name()), (String)PACKAGE_INFO_NAME);
        ClassInfo packageInfo = this.index.getClassByName(packageInfoName);
        return packageInfo != null && this.isAnnotationDeclared(packageInfo, DOT_NAME_VETOED);
    }

    private boolean isAnnotationDeclared(ClassInfo classInfo, Class<? extends Annotation> annotation) {
        return this.isAnnotationDeclared(classInfo, DotName.createSimple((String)annotation.getName()));
    }

    private boolean isAnnotationDeclared(ClassInfo classInfo, DotName requiredAnnotationName) {
        Map annotationsMap = classInfo.annotations();
        List annotations = (List)annotationsMap.get(requiredAnnotationName);
        if (annotations != null) {
            for (AnnotationInstance annotationInstance : annotations) {
                if (!annotationInstance.target().equals(classInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasInjectConstructor() {
        List annotationInstances = (List)this.classInfo.annotations().get(DOT_NAME_INJECT);
        if (annotationInstances != null) {
            for (AnnotationInstance instance : annotationInstances) {
                MethodInfo methodInfo;
                AnnotationTarget target = instance.target();
                if (!(target instanceof MethodInfo) || !(methodInfo = (MethodInfo)target).name().equals(CONSTRUCTOR_METHOD_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    private DotName getPackageName(DotName name) {
        if (name.isComponentized()) {
            return name.prefix();
        }
        int lastIndex = name.local().lastIndexOf(".");
        if (lastIndex == -1) {
            return name;
        }
        return DotName.createSimple((String)name.local().substring(0, lastIndex));
    }

    private boolean isAssignableFrom(String className, Class<?> fromClass) {
        if (className.equals(fromClass.getName())) {
            return true;
        }
        if (Object.class.equals(fromClass)) {
            return false;
        }
        Class<?> superClass = fromClass.getSuperclass();
        if (superClass != null && this.isAssignableFrom(className, superClass)) {
            return true;
        }
        for (Class<?> interfaceClass : fromClass.getInterfaces()) {
            if (!this.isAssignableFrom(className, interfaceClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableTo(DotName name, Class<?> to) {
        if (to.getName().equals(name.toString())) {
            return true;
        }
        if (OBJECT_NAME.equals((Object)name)) {
            return false;
        }
        ClassInfo fromClassInfo = this.index.getClassByName(name);
        if (fromClassInfo == null) {
            Class<?> clazz = this.loadClass(name.toString());
            return to.isAssignableFrom(clazz);
        }
        DotName superName = fromClassInfo.superName();
        if (superName != null && this.isAssignableTo(superName, to)) {
            return true;
        }
        if (fromClassInfo.interfaces() != null) {
            for (DotName interfaceName : fromClassInfo.interfaces()) {
                if (!this.isAssignableTo(interfaceName, to)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsAnnotation(ClassInfo classInfo, DotName requiredAnnotationName, Class<? extends Annotation> requiredAnnotation) {
        if (classInfo.annotations().containsKey(requiredAnnotationName)) {
            return true;
        }
        for (DotName annotation : classInfo.annotations().keySet()) {
            if (!this.annotationClassAnnotationsCache.getValue(annotation).contains(requiredAnnotationName.toString())) continue;
            return true;
        }
        DotName superName = classInfo.superName();
        if (superName != null && !OBJECT_NAME.equals((Object)superName)) {
            ClassInfo superClassInfo = this.index.getClassByName(superName);
            if (superClassInfo == null) {
                return Reflections.containsAnnotation(this.loadClass(superName.toString()), requiredAnnotation);
            }
            if (this.containsAnnotation(superClassInfo, requiredAnnotationName, requiredAnnotation)) {
                return true;
            }
        }
        return false;
    }

    private Class<?> loadClass(String className) {
        log.trace("Loading class with class loader: " + className);
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw CommonLogger.LOG.unableToLoadClass(className);
        }
        return clazz;
    }

    public String toString() {
        return this.classInfo.toString();
    }
}

